/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.List;
import org.apache.tapestry5.internal.plastic.AbstractMethodInvocation;
import org.apache.tapestry5.internal.plastic.InstructionBuilderImpl;
import org.apache.tapestry5.internal.plastic.MethodInvocationBundle;
import org.apache.tapestry5.internal.plastic.PlasticClassImpl;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.plastic.ClassType;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.LocalVariable;
import org.apache.tapestry5.plastic.LocalVariableCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.SwitchCallback;
import org.apache.tapestry5.plastic.TryCatchBlock;
import org.apache.tapestry5.plastic.TryCatchCallback;

class MethodAdviceManager {
    private static final String RETURN_VALUE = "returnValue";
    private final MethodDescription description;
    private final MethodNode advisedMethodNode;
    private final ClassNode invocationClassNode;
    private final List<MethodAdvice> advice = PlasticInternalUtils.newList();
    private final boolean isVoid;
    private final String invocationClassName;
    private final String newMethodName;
    private final String[] constructorTypes;
    private PlasticClassImpl plasticClass;

    MethodAdviceManager(PlasticClassImpl plasticClass, MethodDescription description, MethodNode methodNode) {
        this.plasticClass = plasticClass;
        this.description = description;
        this.advisedMethodNode = methodNode;
        this.isVoid = description.returnType.equals("void");
        this.invocationClassName = String.format("%s$Invocation_%s_%s", plasticClass.className, description.methodName, PlasticUtils.nextUID());
        this.invocationClassNode = new ClassNode();
        this.invocationClassNode.visit(50, 17, plasticClass.nameCache.toInternalName(this.invocationClassName), null, PlasticClassImpl.ABSTRACT_METHOD_INVOCATION_INTERNAL_NAME, new String[]{plasticClass.nameCache.toInternalName(MethodInvocation.class)});
        this.constructorTypes = this.createFieldsAndConstructor();
        this.createReturnValueAccessors();
        this.createSetParameter();
        this.createGetParameter();
        this.newMethodName = String.format("advised$%s_%s", description.methodName, PlasticUtils.nextUID());
        this.createProceedToAdvisedMethod();
    }

    private String[] createFieldsAndConstructor() {
        if (!this.isVoid) {
            this.invocationClassNode.visitField(1, RETURN_VALUE, this.plasticClass.nameCache.toDesc(this.description.returnType), null, null);
        }
        List<String> consTypes = PlasticInternalUtils.newList();
        consTypes.add(Object.class.getName());
        consTypes.add(InstanceContext.class.getName());
        consTypes.add(MethodInvocationBundle.class.getName());
        for (int i = 0; i < this.description.argumentTypes.length; ++i) {
            String type = this.description.argumentTypes[i];
            this.invocationClassNode.visitField(2, "p" + i, this.plasticClass.nameCache.toDesc(type), null, null);
            consTypes.add(type);
        }
        String[] constructorTypes = consTypes.toArray(new String[consTypes.size()]);
        MethodNode cons = new MethodNode(1, "<init>", this.plasticClass.nameCache.toMethodDescriptor("void", constructorTypes), null, null);
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(cons);
        builder.loadThis();
        builder.loadArgument(0);
        builder.loadArgument(1);
        builder.loadArgument(2);
        builder.invokeConstructor(AbstractMethodInvocation.class, Object.class, InstanceContext.class, MethodInvocationBundle.class);
        for (int i = 0; i < this.description.argumentTypes.length; ++i) {
            String name = "p" + i;
            String type = this.description.argumentTypes[i];
            builder.loadThis();
            builder.loadArgument(3 + i);
            builder.putField(this.invocationClassName, name, type);
        }
        builder.returnResult();
        this.invocationClassNode.methods.add(cons);
        return constructorTypes;
    }

    public void add(MethodAdvice advice) {
        this.advice.add(advice);
    }

    private void createReturnValueAccessors() {
        this.addReturnValueSetter();
        this.createReturnValueGetter();
    }

    private InstructionBuilder newMethod(String name, Class returnType, Class ... argumentTypes) {
        MethodNode mn = new MethodNode(1, name, this.plasticClass.nameCache.toMethodDescriptor(returnType, argumentTypes), null, null);
        this.invocationClassNode.methods.add(mn);
        return this.plasticClass.newBuilder(mn);
    }

    private void createReturnValueGetter() {
        InstructionBuilder builder = this.newMethod("getReturnValue", Object.class, new Class[0]);
        if (this.isVoid) {
            builder.loadNull().returnResult();
        } else {
            builder.loadThis().getField(this.invocationClassName, RETURN_VALUE, this.description.returnType).boxPrimitive(this.description.returnType).returnResult();
        }
    }

    private void addReturnValueSetter() {
        InstructionBuilder builder = this.newMethod("setReturnValue", MethodInvocation.class, Object.class);
        if (this.isVoid) {
            builder.throwException(IllegalArgumentException.class, String.format("Method %s of class %s is void, setting a return value is not allowed.", this.description, this.plasticClass.className));
        } else {
            builder.loadThis().loadArgument(0);
            builder.castOrUnbox(this.description.returnType);
            builder.putField(this.invocationClassName, RETURN_VALUE, this.description.returnType);
            builder.loadThis().invoke(AbstractMethodInvocation.class, Void.TYPE, "clearCheckedException", new Class[0]);
            builder.loadThis().returnResult();
        }
    }

    private void createGetParameter() {
        InstructionBuilder builder = this.newMethod("getParameter", Object.class, Integer.TYPE);
        if (this.description.argumentTypes.length == 0) {
            this.indexOutOfRange(builder);
        } else {
            builder.loadArgument(0);
            builder.startSwitch(0, this.description.argumentTypes.length - 1, new SwitchCallback(){

                @Override
                public void doSwitch(SwitchBlock block) {
                    for (int i = 0; i < ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes.length; ++i) {
                        final int index = i;
                        block.addCase(i, false, new InstructionBuilderCallback(){

                            @Override
                            public void doBuild(InstructionBuilder builder) {
                                String type = ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes[index];
                                builder.loadThis();
                                builder.getField(MethodAdviceManager.this.invocationClassName, "p" + index, type).boxPrimitive(type).returnResult();
                            }
                        });
                    }
                }
            });
        }
    }

    private void indexOutOfRange(InstructionBuilder builder) {
        builder.throwException(IllegalArgumentException.class, "Parameter index out of range.");
    }

    private void createSetParameter() {
        InstructionBuilder builder = this.newMethod("setParameter", MethodInvocation.class, Integer.TYPE, Object.class);
        if (this.description.argumentTypes.length == 0) {
            this.indexOutOfRange(builder);
        } else {
            builder.loadArgument(0).startSwitch(0, this.description.argumentTypes.length - 1, new SwitchCallback(){

                @Override
                public void doSwitch(SwitchBlock block) {
                    for (int i = 0; i < ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes.length; ++i) {
                        final int index = i;
                        block.addCase(i, true, new InstructionBuilderCallback(){

                            @Override
                            public void doBuild(InstructionBuilder builder) {
                                String type = ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes[index];
                                builder.loadThis();
                                builder.loadArgument(1).castOrUnbox(type);
                                builder.putField(MethodAdviceManager.this.invocationClassName, "p" + index, type);
                            }
                        });
                    }
                }
            });
            builder.loadThis().returnResult();
        }
    }

    private void createNewMethod() {
        String[] exceptions = this.advisedMethodNode.exceptions == null ? null : this.advisedMethodNode.exceptions.toArray(new String[0]);
        MethodNode mn = new MethodNode(this.advisedMethodNode.access & 0xFFFFFFFD, this.newMethodName, this.advisedMethodNode.desc, this.advisedMethodNode.signature, exceptions);
        this.advisedMethodNode.accept(mn);
        this.plasticClass.classNode.methods.add(mn);
    }

    private void createProceedToAdvisedMethod() {
        InstructionBuilder builder = this.newMethod("proceedToAdvisedMethod", Void.TYPE, new Class[0]);
        if (!this.isVoid) {
            builder.loadThis();
        }
        builder.loadThis().invoke(AbstractMethodInvocation.class, Object.class, "getInstance", new Class[0]).checkcast(this.plasticClass.className);
        for (int i = 0; i < this.description.argumentTypes.length; ++i) {
            String type = this.description.argumentTypes[i];
            builder.loadThis().getField(this.invocationClassName, "p" + i, type);
        }
        builder.startTryCatch(new TryCatchCallback(){

            @Override
            public void doBlock(TryCatchBlock block) {
                block.addTry(new InstructionBuilderCallback(){

                    @Override
                    public void doBuild(InstructionBuilder builder) {
                        builder.invokeVirtual(((MethodAdviceManager)MethodAdviceManager.this).plasticClass.className, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType, MethodAdviceManager.this.newMethodName, ((MethodAdviceManager)MethodAdviceManager.this).description.argumentTypes);
                        if (!MethodAdviceManager.this.isVoid) {
                            builder.putField(MethodAdviceManager.this.invocationClassName, MethodAdviceManager.RETURN_VALUE, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType);
                        }
                        builder.returnResult();
                    }
                });
                for (String exceptionName : ((MethodAdviceManager)MethodAdviceManager.this).description.checkedExceptionTypes) {
                    if (!((MethodAdviceManager)MethodAdviceManager.this).plasticClass.pool.isCheckedException(exceptionName)) continue;
                    block.addCatch(exceptionName, new InstructionBuilderCallback(){

                        @Override
                        public void doBuild(InstructionBuilder builder) {
                            builder.loadThis().swap();
                            builder.invoke(AbstractMethodInvocation.class, MethodInvocation.class, "setCheckedException", Exception.class);
                            builder.returnResult();
                        }
                    });
                }
            }
        });
    }

    void rewriteOriginalMethod() {
        this.createNewMethod();
        this.plasticClass.pool.realize(this.plasticClass.className, ClassType.METHOD_INVOCATION, this.invocationClassNode);
        String fieldName = String.format("methodinvocationbundle_%s_%s", this.description.methodName, PlasticUtils.nextUID());
        MethodAdvice[] adviceArray = this.advice.toArray(new MethodAdvice[this.advice.size()]);
        MethodInvocationBundle bundle = new MethodInvocationBundle(this.plasticClass.className, this.description, adviceArray);
        this.plasticClass.classNode.visitField(18, fieldName, this.plasticClass.nameCache.toDesc(this.constructorTypes[2]), null, null);
        this.plasticClass.initializeFieldFromStaticContext(fieldName, this.constructorTypes[2], bundle);
        this.advisedMethodNode.instructions.clear();
        this.advisedMethodNode.tryCatchBlocks.clear();
        if (this.advisedMethodNode.localVariables != null) {
            this.advisedMethodNode.localVariables.clear();
        }
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(this.description, this.advisedMethodNode);
        builder.newInstance(this.invocationClassName).dupe();
        builder.loadThis();
        builder.loadThis().getField(this.plasticClass.className, this.plasticClass.getInstanceContextFieldName(), this.constructorTypes[1]);
        builder.loadThis().getField(this.plasticClass.className, fieldName, this.constructorTypes[2]);
        builder.loadArguments();
        builder.invokeConstructor(this.invocationClassName, this.constructorTypes);
        builder.startVariable(this.invocationClassName, new LocalVariableCallback(){

            @Override
            public void doBuild(final LocalVariable invocation, InstructionBuilder builder) {
                builder.dupe().storeVariable(invocation);
                builder.invoke(AbstractMethodInvocation.class, MethodInvocation.class, "proceed", new Class[0]);
                if (((MethodAdviceManager)MethodAdviceManager.this).description.checkedExceptionTypes.length > 0) {
                    builder.invoke(MethodInvocation.class, Boolean.TYPE, "didThrowCheckedException", new Class[0]);
                    builder.when(Condition.NON_ZERO, new InstructionBuilderCallback(){

                        @Override
                        public void doBuild(InstructionBuilder builder) {
                            builder.loadVariable(invocation).loadTypeConstant(Exception.class);
                            builder.invokeVirtual(MethodAdviceManager.this.invocationClassName, Throwable.class.getName(), "getCheckedException", Class.class.getName());
                            builder.throwException();
                        }
                    });
                }
                if (!MethodAdviceManager.this.isVoid) {
                    builder.loadVariable(invocation).getField(MethodAdviceManager.this.invocationClassName, MethodAdviceManager.RETURN_VALUE, ((MethodAdviceManager)MethodAdviceManager.this).description.returnType);
                }
                builder.returnResult();
            }
        });
    }
}

