/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.Externalizable;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.storage.StorageUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer$;
import org.apache.spark.util.io.ChunkedByteBufferFileRegion;
import org.apache.spark.util.io.ChunkedByteBufferInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-g!\u0002\u0014(\u0001-\n\u0004\u0002C \u0001\u0005\u0003\u0007I\u0011A!\t\u00119\u0003!\u00111A\u0005\u0002=C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006KA\u0011\u0005\u0006-\u0002!\ta\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u0019\u0001\u0007\u0001)A\u0005;\"1\u0011\r\u0001Q!\n\tDq!\u001a\u0001A\u0002\u0013%a\rC\u0004k\u0001\u0001\u0007I\u0011B6\t\r5\u0004\u0001\u0015)\u0003h\u0011\u0015q\u0007\u0001\"\u0001g\u0011\u00151\u0006\u0001\"\u0001p\u0011\u00151\u0006\u0001\"\u0001q\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002\"CA \u0001E\u0005I\u0011AA!\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002>\u0001!\t!!\u001b\b\u0011\u0005-t\u0005#\u0001,\u0003[2qAJ\u0014\t\u0002-\ny\u0007\u0003\u0004W5\u0011\u0005\u0011Q\u0010\u0005\t\u0003\u007fR\"\u0019!C\u00059\"9\u0011\u0011\u0011\u000e!\u0002\u0013i\u0006\u0002CAB5\t\u0007I\u0011\u0002/\t\u000f\u0005\u0015%\u0004)A\u0005;\"9\u0011q\u0011\u000e\u0005\u0002\u0005%\u0005bBAP5\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003?SB\u0011BAW\u0011\u001d\tIL\u0007C\u0001\u0003wC\u0011\"!1\u001b#\u0003%\t!a1\t\u0013\u0005\u001d'$!A\u0005\n\u0005%'!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe*\u0011\u0001&K\u0001\u0003S>T!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sON\u0019\u0001A\r\u001e\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t1qJ\u00196fGR\u0004\"aO\u001f\u000e\u0003qR!\u0001\u000b\u001c\n\u0005yb$AD#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z\u0001\u0007G\",hn[:\u0004\u0001U\t!\tE\u0002D\r\"k\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017Z\n1A\\5p\u0013\ti%J\u0001\u0006CsR,')\u001e4gKJ\f!b\u00195v].\u001cx\fJ3r)\t\u00016\u000b\u0005\u0002D#&\u0011!\u000b\u0012\u0002\u0005+:LG\u000fC\u0004U\u0005\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013'A\u0004dQVt7n\u001d\u0011\u0002\rqJg.\u001b;?)\tA&\f\u0005\u0002Z\u00015\tq\u0005C\u0003@\t\u0001\u0007!)\u0001\u000bck\u001a4WM],sSR,7\t[;oWNK'0Z\u000b\u0002;B\u00111IX\u0005\u0003?\u0012\u00131!\u00138u\u0003U\u0011WO\u001a4fe^\u0013\u0018\u000e^3DQVt7nU5{K\u0002\n\u0001\u0002Z5ta>\u001cX\r\u001a\t\u0003\u0007\u000eL!\u0001\u001a#\u0003\u000f\t{w\u000e\\3b]\u0006)ql]5{KV\tq\r\u0005\u0002DQ&\u0011\u0011\u000e\u0012\u0002\u0005\u0019>tw-A\u0005`g&TXm\u0018\u0013fcR\u0011\u0001\u000b\u001c\u0005\b)&\t\t\u00111\u0001h\u0003\u0019y6/\u001b>fA\u0005!1/\u001b>f)\u0005AFC\u0001-r\u0011\u0015\u0011X\u00021\u0001I\u0003)\u0011\u0017\u0010^3Ck\u001a4WM]\u0001\u000boJLG/\u001a$vY2LHC\u0001)v\u0011\u00151h\u00021\u0001x\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"\u0001_>\u000e\u0003eT!A\u001f&\u0002\u0011\rD\u0017M\u001c8fYNL!\u0001`=\u0003']\u0013\u0018\u000e^1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\u0002\u001b]\u0014\u0018\u000e^3FqR,'O\\1m)\t\u0001v\u0010C\u0004\u0002\u0002=\u0001\r!a\u0001\u0002\u0007=,H\u000fE\u0002<\u0003\u000bI1!a\u0002=\u00051y%M[3di>+H\u000f];u\u00031\u0011X-\u00193FqR,'O\\1m)\r\u0001\u0016Q\u0002\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0003\tIg\u000eE\u0002<\u0003'I1!!\u0006=\u0005-y%M[3di&s\u0007/\u001e;\u0002\u000fQ|g*\u001a;usV\u0011\u00111\u0004\t\u00043\u0006u\u0011bAA\u0010O\tY2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:GS2,'+Z4j_:\fq\u0001^8BeJ\f\u00170\u0006\u0002\u0002&A!1IRA\u0014!\r\u0019\u0015\u0011F\u0005\u0004\u0003W!%\u0001\u0002\"zi\u0016\fA\u0002^8CsR,')\u001e4gKJ,\u0012\u0001S\u0001\u000ei>Le\u000e];u'R\u0014X-Y7\u0015\t\u0005U\u00121\b\t\u0004w\u0005]\u0012bAA\u001dy\tY\u0011J\u001c9viN#(/Z1n\u0011!\ti\u0004\u0006I\u0001\u0002\u0004\u0011\u0017a\u00023jgB|7/Z\u0001\u0018i>Le\u000e];u'R\u0014X-Y7%I\u00164\u0017-\u001e7uIE*\"!a\u0011+\u0007\t\f)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t\u0006R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%9W\r^\"ik:\\7\u000fF\u0001C\u0003\u0011\u0019w\u000e]=\u0015\u0007a\u000by\u0006C\u0004\u0002b]\u0001\r!a\u0019\u0002\u0013\u0005dGn\\2bi>\u0014\b#B\"\u0002fuC\u0015bAA4\t\nIa)\u001e8di&|g.\r\u000b\u0002!\u0006\t2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\u0011\u0005eS2#\u0002\u000e\u0002r\u0005]\u0004cA\"\u0002t%\u0019\u0011Q\u000f#\u0003\r\u0005s\u0017PU3g!\r\u0019\u0015\u0011P\u0005\u0004\u0003w\"%\u0001D*fe&\fG.\u001b>bE2,GCAA7\u0003E\u0019\u0005*\u0016(L?\n+fIR#S?NK%,R\u0001\u0013\u0007\"+fjS0C+\u001a3UIU0T\u0013j+\u0005%A\rN\u0013:KU*V'`\u0007\"+fjS0C+\u001a3UIU0T\u0013j+\u0015AG'J\u001d&kU+T0D\u0011Vs5j\u0018\"V\r\u001a+%kX*J5\u0016\u0003\u0013!\u00054s_6l\u0015M\\1hK\u0012\u0014UO\u001a4feR\u0019\u0001,a#\t\u000f\u00055\u0005\u00051\u0001\u0002\u0010\u0006!A-\u0019;b!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000baAY;gM\u0016\u0014(bAAMW\u00059a.\u001a;x_J\\\u0017\u0002BAO\u0003'\u0013Q\"T1oC\u001e,GMQ;gM\u0016\u0014\u0018\u0001\u00034s_64\u0015\u000e\\3\u0015\u0007a\u000b\u0019\u000bC\u0004\u0002&\u0006\u0002\r!a*\u0002\t\u0019LG.\u001a\t\u0004w\u0005%\u0016bAAVy\t!a)\u001b7f)\u001dA\u0016qVAY\u0003kCq!!*#\u0001\u0004\t9\u000b\u0003\u0004\u00024\n\u0002\raZ\u0001\u0007_\u001a47/\u001a;\t\r\u0005]&\u00051\u0001h\u0003\u0019aWM\\4uQ\u00069Rm\u001d;j[\u0006$XMQ;gM\u0016\u00148\t[;oWNK'0\u001a\u000b\u0004;\u0006u\u0006\u0002CA`GA\u0005\t\u0019A4\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f\u0003\u0005*7\u000f^5nCR,')\u001e4gKJ\u001c\u0005.\u001e8l'&TX\r\n3fM\u0006,H\u000e\u001e\u00132+\t\t)MK\u0002h\u0003\u000b\n1B]3bIJ+7o\u001c7wKR\t!\u0007")
public class ChunkedByteBuffer
implements Externalizable {
    private ByteBuffer[] chunks;
    private final int bufferWriteChunkSize;
    private boolean disposed;
    private long _size;

    public static long estimateBufferChunkSize$default$1() {
        return ChunkedByteBuffer$.MODULE$.estimateBufferChunkSize$default$1();
    }

    public static int estimateBufferChunkSize(long l) {
        return ChunkedByteBuffer$.MODULE$.estimateBufferChunkSize(l);
    }

    public static ChunkedByteBuffer fromFile(File file) {
        return ChunkedByteBuffer$.MODULE$.fromFile(file);
    }

    public static ChunkedByteBuffer fromManagedBuffer(ManagedBuffer managedBuffer) {
        return ChunkedByteBuffer$.MODULE$.fromManagedBuffer(managedBuffer);
    }

    public ByteBuffer[] chunks() {
        return this.chunks;
    }

    public void chunks_$eq(ByteBuffer[] x$1) {
        this.chunks = x$1;
    }

    private int bufferWriteChunkSize() {
        return this.bufferWriteChunkSize;
    }

    private long _size() {
        return this._size;
    }

    private void _size_$eq(long x$1) {
        this._size = x$1;
    }

    public long size() {
        return this._size();
    }

    public void writeFully(WritableByteChannel channel) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).foreach((Function1 & Serializable & scala.Serializable)bytes -> {
            ChunkedByteBuffer.$anonfun$writeFully$1(this, channel, bytes);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        out.writeInt(this.chunks().length);
        ByteBuffer[] chunksCopy = this.getChunks();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunksCopy)).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            out.writeInt(buffer.limit());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunksCopy)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Utils$.MODULE$.writeByteBuffer(x$4, out);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        int chunksNum = in.readInt();
        Range indices = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), chunksNum);
        IndexedSeq chunksSize = (IndexedSeq)indices.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$5 -> in.readInt(), IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer[] chunks = new ByteBuffer[chunksNum];
        indices.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int chunkSize = BoxesRunTime.unboxToInt((Object)chunksSize.apply(i));
            byte[] arr = new byte[chunkSize];
            in.readFully(arr, 0, chunkSize);
            chunks$1[i] = ByteBuffer.wrap(arr);
        });
        this.chunks_$eq(chunks);
        this._size_$eq(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunks)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.limit()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public ChunkedByteBufferFileRegion toNetty() {
        return new ChunkedByteBufferFileRegion(this, this.bufferWriteChunkSize());
    }

    public byte[] toArray() {
        if (this.size() >= 0x7FFFFFF0L) {
            throw new UnsupportedOperationException(new StringBuilder(75).append("cannot call toArray because buffer size (").append(this.size()).append(" bytes) exceeds maximum array size").toString());
        }
        ByteArrayWritableChannel byteChannel = new ByteArrayWritableChannel((int)this.size());
        this.writeFully((WritableByteChannel)byteChannel);
        byteChannel.close();
        return byteChannel.getData();
    }

    public ByteBuffer toByteBuffer() {
        if (this.chunks().length == 1) {
            return ((ByteBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).head()).duplicate();
        }
        return ByteBuffer.wrap(this.toArray());
    }

    public InputStream toInputStream(boolean dispose) {
        return new ChunkedByteBufferInputStream(this, dispose);
    }

    public boolean toInputStream$default$1() {
        return false;
    }

    public ByteBuffer[] getChunks() {
        return (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.duplicate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    public ChunkedByteBuffer copy(Function1<Object, ByteBuffer> allocator) {
        ByteBuffer[] copiedChunks = (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).map((Function1 & Serializable & scala.Serializable)chunk -> {
            ByteBuffer newChunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)chunk.limit()));
            newChunk.put((ByteBuffer)chunk);
            newChunk.flip();
            return newChunk;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        return new ChunkedByteBuffer(copiedChunks);
    }

    public void dispose() {
        if (!this.disposed) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                StorageUtils$.MODULE$.dispose(buffer);
                return BoxedUnit.UNIT;
            });
            this.disposed = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$3(ByteBuffer x$1) {
        return x$1.position() == 0;
    }

    public static final /* synthetic */ long $anonfun$bufferWriteChunkSize$1(SparkEnv x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2.conf().get(package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE()));
    }

    public static final /* synthetic */ void $anonfun$writeFully$1(ChunkedByteBuffer $this, WritableByteChannel channel$1, ByteBuffer bytes) {
        int originalLimit = bytes.limit();
        while (bytes.hasRemaining()) {
            int ioSize = Math.min(bytes.remaining(), $this.bufferWriteChunkSize());
            bytes.limit(bytes.position() + ioSize);
            channel$1.write(bytes);
            bytes.limit(originalLimit);
        }
    }

    public ChunkedByteBuffer(ByteBuffer[] chunks) {
        this.chunks = chunks;
        Predef$.MODULE$.require(this.chunks() != null, (Function0 & Serializable & scala.Serializable)() -> "chunks must not be null");
        Predef$.MODULE$.require(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).contains(null), (Function0 & Serializable & scala.Serializable)() -> "chunks must not contain null");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChunkedByteBuffer.$anonfun$new$3(x$1))), (Function0 & Serializable & scala.Serializable)() -> "chunks' positions must be 0");
        this.bufferWriteChunkSize = (int)BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ChunkedByteBuffer.$anonfun$bufferWriteChunkSize$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE().defaultValue().get())));
        this.disposed = false;
        this._size = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.limit()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public ChunkedByteBuffer() {
        this((ByteBuffer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    public ChunkedByteBuffer(ByteBuffer byteBuffer) {
        this((ByteBuffer[])((Object[])new ByteBuffer[]{byteBuffer}));
    }
}

