/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;

public class HashMapToInt<K>
implements Map<K, Integer>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3624988207265L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected Node<K>[] buckets;
    protected int nullV = -1;
    protected int size;

    public HashMapToInt(int capacity) {
        this.alloc(Math.max(capacity, 16));
    }

    protected void alloc(int size) {
        Node[] tmp = new Node[size];
        this.buckets = tmp;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.nullV != -1;
        }
        return this.getI(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            for (Map.Entry<K, Integer> v : this.entrySet()) {
                if (!v.getValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int i = this.getI(key);
        if (i != -1) {
            return i;
        }
        return null;
    }

    public int getI(K key) {
        if (key == null) {
            return this.nullV;
        }
        int ix = this.hash(key);
        Node<K> b = this.buckets[ix];
        if (b != null) {
            do {
                if (!b.key.equals(key)) continue;
                return b.value;
            } while ((b = b.next) != null);
        }
        return -1;
    }

    public int hash(K key) {
        return Math.abs(key.hashCode()) % this.buckets.length;
    }

    @Override
    public Integer put(K key, Integer value) {
        int i = this.putI(key, value);
        if (i != -1) {
            return i;
        }
        return null;
    }

    @Override
    public Integer putIfAbsent(K key, Integer value) {
        int i = this.putIfAbsentI(key, value);
        if (i != -1) {
            return i;
        }
        return null;
    }

    public int putIfAbsentI(K key, int value) {
        if (key == null) {
            if (this.nullV == -1) {
                ++this.size;
                this.nullV = value;
                return -1;
            }
            return this.nullV;
        }
        int ix = this.hash(key);
        Node<K> b = this.buckets[ix];
        if (b == null) {
            return this.createBucket(ix, key, value);
        }
        return this.putIfAbsentBucket(ix, key, value);
    }

    public int putIfAbsentReturnVal(K key, int value) {
        if (key == null) {
            if (this.nullV == -1) {
                ++this.size;
                this.nullV = value;
                return -1;
            }
            return this.nullV;
        }
        int ix = this.hash(key);
        Node<K> b = this.buckets[ix];
        if (b == null) {
            return this.createBucketReturnVal(ix, key, value);
        }
        return this.putIfAbsentBucketReturnval(ix, key, value);
    }

    private int putIfAbsentBucket(int ix, K key, int value) {
        Node<K> b = this.buckets[ix];
        while (!b.key.equals(key)) {
            if (b.next == null) {
                b.setNext(new Node<K>(key, value, null));
                ++this.size;
                this.resize();
                return -1;
            }
            b = b.next;
        }
        return b.value;
    }

    private int putIfAbsentBucketReturnval(int ix, K key, int value) {
        Node<K> b = this.buckets[ix];
        while (!b.key.equals(key)) {
            if (b.next == null) {
                b.setNext(new Node<K>(key, value, null));
                ++this.size;
                this.resize();
                return value;
            }
            b = b.next;
        }
        return b.value;
    }

    public int putI(K key, int value) {
        if (key == null) {
            int tmp = this.nullV;
            this.nullV = value;
            if (tmp != -1) {
                ++this.size;
            }
            return tmp;
        }
        int ix = this.hash(key);
        Node<K> b = this.buckets[ix];
        if (b == null) {
            return this.createBucket(ix, key, value);
        }
        return this.addToBucket(ix, key, value);
    }

    private int createBucket(int ix, K key, int value) {
        this.buckets[ix] = new Node<K>(key, value, null);
        ++this.size;
        return -1;
    }

    private int createBucketReturnVal(int ix, K key, int value) {
        this.buckets[ix] = new Node<K>(key, value, null);
        ++this.size;
        return value;
    }

    private int addToBucket(int ix, K key, int value) {
        Node<K> b = this.buckets[ix];
        while (true) {
            if (b.key.equals(key)) {
                int tmp = b.getValue();
                b.setValue(value);
                return tmp;
            }
            if (b.next == null) {
                b.setNext(new Node<K>(key, value, null));
                ++this.size;
                this.resize();
                return -1;
            }
            b = b.next;
        }
    }

    private void resize() {
        if ((float)this.size > (float)this.buckets.length * 0.75f) {
            Node[] tmp = new Node[this.buckets.length * 2];
            Node<K>[] oldBuckets = this.buckets;
            this.buckets = tmp;
            this.size = this.nullV == -1 ? 0 : 1;
            for (Node<K> n : oldBuckets) {
                if (n == null) continue;
                do {
                    this.put(n.key, n.value);
                } while ((n = n.next) != null);
            }
        }
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException("Unimplemented method 'remove'");
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> m) {
        throw new UnsupportedOperationException("Unimplemented method 'putAll'");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unimplemented method 'clear'");
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("Unimplemented method 'keySet'");
    }

    @Override
    public Collection<Integer> values() {
        throw new UnsupportedOperationException("Unimplemented method 'values'");
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Integer> action) {
        if (this.nullV != -1) {
            action.accept(null, this.nullV);
        }
        for (Node<K> n : this.buckets) {
            if (n == null) continue;
            do {
                action.accept(n.key, n.value);
            } while ((n = n.next) != null);
        }
    }

    public Array<K> inverse(Types.ValueType t) {
        Array<?> ar = this.containsKey(null) ? ArrayFactory.allocateOptional(t, this.size()) : ArrayFactory.allocate(t, this.size());
        this.forEach((BiConsumer<? super K, ? super Integer>)((BiConsumer<Object, Integer>)(k, v) -> ar.set((int)v, k)));
        return ar;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 3);
        this.forEach((BiConsumer<? super K, ? super Integer>)((BiConsumer<Object, Integer>)(k, v) -> sb.append("(" + k + "\u2192" + v + ")")));
        return sb.toString();
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, Integer>> {
        Node<K> next;
        int bucketId = 0;

        protected EntryIterator() {
            if (HashMapToInt.this.nullV != -1) {
                this.next = new Node<Object>(null, HashMapToInt.this.nullV, null);
            } else {
                while (this.bucketId < HashMapToInt.this.buckets.length) {
                    if (HashMapToInt.this.buckets[this.bucketId] != null) {
                        this.next = HashMapToInt.this.buckets[this.bucketId];
                        break;
                    }
                    ++this.bucketId;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, Integer> next() {
            Node e = this.next;
            if (e.next != null) {
                this.next = e.next;
            } else {
                while (++this.bucketId < HashMapToInt.this.buckets.length) {
                    if (HashMapToInt.this.buckets[this.bucketId] != null) {
                        this.next = HashMapToInt.this.buckets[this.bucketId];
                        break;
                    }
                    ++this.bucketId;
                }
                if (this.bucketId >= HashMapToInt.this.buckets.length) {
                    this.next = null;
                }
            }
            return e;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, Integer>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return HashMapToInt.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, Integer>> iterator() {
            return new EntryIterator();
        }
    }

    private static class Node<K>
    implements Map.Entry<K, Integer> {
        final K key;
        int value;
        Node<K> next;

        Node(K key, int value, Node<K> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public final void setNext(Node<K> n) {
            this.next = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            this.value = value;
            return this.value;
        }
    }
}

