/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedWriteBlock
implements WritableComparable<CompressedWriteBlock>,
Serializable {
    private static final long serialVersionUID = -587986086067463499L;
    public MatrixBlock mb;

    public CompressedWriteBlock() {
    }

    public CompressedWriteBlock(MatrixBlock mb) {
        this.mb = mb;
    }

    public void write(DataOutput out) throws IOException {
        if (this.mb instanceof CompressedMatrixBlock) {
            out.writeByte(CONTENT.Comp.ordinal());
        } else {
            out.writeByte(CONTENT.MB.ordinal());
        }
        this.mb.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        switch (CONTENT.values()[in.readByte()]) {
            case Comp: {
                this.mb = CompressedMatrixBlock.read(in);
                break;
            }
            case MB: {
                this.mb = new MatrixBlock();
                this.mb.readFields(in);
            }
        }
    }

    public MatrixBlock get() {
        return this.mb;
    }

    public int compareTo(CompressedWriteBlock arg0) {
        throw new RuntimeException("CompareTo should never be called for WriteBlock.");
    }

    private static enum CONTENT {
        Comp,
        MB;

    }
}

