/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.mlcontext;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.sysds.api.mlcontext.FrameFormat;
import org.apache.sysds.api.mlcontext.FrameMetadata;
import org.apache.sysds.api.mlcontext.FrameSchema;
import org.apache.sysds.api.mlcontext.MLContextException;
import org.apache.sysds.api.mlcontext.MLContextUtil;
import org.apache.sysds.api.mlcontext.MatrixFormat;
import org.apache.sysds.api.mlcontext.MatrixMetadata;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.spark.data.DatasetObject;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.instructions.spark.functions.ConvertStringToLongTextPair;
import org.apache.sysds.runtime.instructions.spark.functions.CopyTextInputFunction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class MLContextConversionUtil {
    public static MatrixObject doubleMatrixToMatrixObject(String variableName, double[][] doubleMatrix) {
        return MLContextConversionUtil.doubleMatrixToMatrixObject(variableName, doubleMatrix, null);
    }

    public static MatrixObject doubleMatrixToMatrixObject(String variableName, double[][] doubleMatrix, MatrixMetadata matrixMetadata) {
        try {
            MatrixBlock matrixBlock = DataConverter.convertToMatrixBlock(doubleMatrix);
            MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics(matrixBlock.getNumRows(), matrixBlock.getNumColumns(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            MatrixObject matrixObject = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY));
            matrixObject.acquireModify(matrixBlock);
            matrixObject.release();
            return matrixObject;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting double[][] array to MatrixObject", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MatrixObject urlToMatrixObject(URL url, MatrixMetadata matrixMetadata) {
        try (InputStream is = url.openStream();){
            List lines = IOUtils.readLines((InputStream)is, (Charset)Charset.defaultCharset());
            JavaRDD javaRDD = MLContextConversionUtil.jsc().parallelize(lines);
            if (matrixMetadata == null || matrixMetadata.getMatrixFormat() == MatrixFormat.CSV) {
                MatrixObject matrixObject = MLContextConversionUtil.javaRDDStringCSVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
                return matrixObject;
            }
            if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                MatrixObject matrixObject = MLContextConversionUtil.javaRDDStringIJVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
                return matrixObject;
            }
            MatrixObject matrixObject = null;
            return matrixObject;
        }
        catch (Exception e) {
            throw new MLContextException("Exception converting URL to MatrixObject", e);
        }
    }

    public static MatrixObject matrixBlockToMatrixObject(String variableName, MatrixBlock matrixBlock, MatrixMetadata matrixMetadata) {
        try {
            MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
            MatrixObject matrixObject = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY));
            matrixObject.acquireModify(matrixBlock);
            matrixObject.release();
            return matrixObject;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting MatrixBlock to MatrixObject", e);
        }
    }

    public static FrameObject frameBlockToFrameObject(String variableName, FrameBlock frameBlock, FrameMetadata frameMetadata) {
        try {
            MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
            MetaDataFormat mtd = new MetaDataFormat(mc, Types.FileFormat.BINARY);
            FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), mtd, frameMetadata.getFrameSchema().getSchema().toArray(new Types.ValueType[0]));
            frameObject.acquireModify(frameBlock);
            frameObject.release();
            return frameObject;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting FrameBlock to FrameObject", e);
        }
    }

    public static MatrixObject binaryBlocksToMatrixObject(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks) {
        return MLContextConversionUtil.binaryBlocksToMatrixObject(binaryBlocks, null);
    }

    public static MatrixObject binaryBlocksToMatrixObject(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata) {
        return MLContextConversionUtil.binaryBlocksToMatrixObject(binaryBlocks, matrixMetadata, true);
    }

    private static MatrixObject binaryBlocksToMatrixObject(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata, boolean copy) {
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD<MatrixIndexes, MatrixBlock> javaPairRdd = SparkUtils.copyBinaryBlockMatrix(binaryBlocks, copy);
        MatrixObject matrixObject = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY));
        matrixObject.setRDDHandle(new RDDObject(javaPairRdd));
        return matrixObject;
    }

    public static MatrixBlock binaryBlocksToMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata) {
        try {
            MatrixBlock matrixBlock = SparkExecutionContext.toMatrixBlock(binaryBlocks, matrixMetadata.getNumRows().intValue(), matrixMetadata.getNumColumns().intValue(), (int)matrixMetadata.getBlocksize(), (long)matrixMetadata.getNumNonZeros());
            return matrixBlock;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting binary blocks to MatrixBlock", e);
        }
    }

    public static FrameObject binaryBlocksToFrameObject(JavaPairRDD<Long, FrameBlock> binaryBlocks) {
        return MLContextConversionUtil.binaryBlocksToFrameObject(binaryBlocks, null);
    }

    public static FrameObject binaryBlocksToFrameObject(JavaPairRDD<Long, FrameBlock> binaryBlocks, FrameMetadata frameMetadata) {
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        Types.ValueType[] schema = frameMetadata != null ? frameMetadata.getFrameSchema().getSchema().toArray(new Types.ValueType[0]) : UtilFunctions.nCopies((int)mc.getCols(), Types.ValueType.STRING);
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY), schema);
        frameObject.setRDDHandle(new RDDObject(binaryBlocks));
        return frameObject;
    }

    public static MatrixObject dataFrameToMatrixObject(Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToMatrixObject(dataFrame, null);
    }

    public static MatrixObject dataFrameToMatrixObject(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        matrixMetadata = matrixMetadata != null ? matrixMetadata : new MatrixMetadata();
        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlock = MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, matrixMetadata);
        MatrixObject mo = MLContextConversionUtil.binaryBlocksToMatrixObject(binaryBlock, matrixMetadata, false);
        mo.getRDDHandle().addLineageChild(new DatasetObject(dataFrame, MLContextConversionUtil.isDataFrameWithIDColumn(matrixMetadata), MLContextConversionUtil.isVectorBasedDataFrame(matrixMetadata)));
        return mo;
    }

    public static FrameObject dataFrameToFrameObject(Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToFrameObject(dataFrame, null);
    }

    public static FrameObject dataFrameToFrameObject(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        try {
            if (frameMetadata == null) {
                frameMetadata = new FrameMetadata();
            }
            MLContextConversionUtil.determineFrameFormatIfNeeded(dataFrame, frameMetadata);
            boolean containsID = MLContextConversionUtil.isDataFrameWithIDColumn(frameMetadata);
            MatrixCharacteristics mc = frameMetadata.asMatrixCharacteristics();
            if (mc == null) {
                mc = new MatrixCharacteristics();
            }
            Pair<String[], Types.ValueType[]> ret = new Pair<String[], Types.ValueType[]>();
            JavaPairRDD<Long, FrameBlock> binaryBlock = FrameRDDConverterUtils.dataFrameToBinaryBlock(MLContextConversionUtil.jsc(), dataFrame, mc, containsID, ret);
            frameMetadata.setFrameSchema(new FrameSchema(Arrays.asList(ret.getValue())));
            frameMetadata.setMatrixCharacteristics(mc);
            return MLContextConversionUtil.binaryBlocksToFrameObject(binaryBlock, frameMetadata);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting DataFrame to FrameObject", e);
        }
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> dataFrameToMatrixBinaryBlocks(Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, null);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> dataFrameToMatrixBinaryBlocks(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        MLContextConversionUtil.determineMatrixFormatIfNeeded(dataFrame, matrixMetadata);
        MatrixCharacteristics mc = matrixMetadata != null && matrixMetadata.asMatrixCharacteristics() != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        boolean containsID = MLContextConversionUtil.isDataFrameWithIDColumn(matrixMetadata);
        boolean isVector = MLContextConversionUtil.isVectorBasedDataFrame(matrixMetadata);
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.dataFrameToBinaryBlock(MLContextConversionUtil.jsc(), dataFrame, mc, containsID, isVector);
        if (matrixMetadata != null) {
            matrixMetadata.setMatrixCharacteristics(mc);
        }
        return out;
    }

    public static JavaPairRDD<Long, FrameBlock> dataFrameToFrameBinaryBlocks(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        throw new MLContextException("dataFrameToFrameBinaryBlocks is unimplemented");
    }

    public static void determineMatrixFormatIfNeeded(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        if (matrixMetadata == null) {
            return;
        }
        MatrixFormat matrixFormat = matrixMetadata.getMatrixFormat();
        if (matrixFormat != null) {
            return;
        }
        StructType schema = dataFrame.schema();
        boolean hasID = false;
        try {
            schema.fieldIndex("__INDEX");
            hasID = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StructField[] fields = schema.fields();
        MatrixFormat mf = null;
        mf = hasID ? (fields[1].dataType() instanceof VectorUDT ? MatrixFormat.DF_VECTOR_WITH_INDEX : MatrixFormat.DF_DOUBLES_WITH_INDEX) : (fields[0].dataType() instanceof VectorUDT ? MatrixFormat.DF_VECTOR : MatrixFormat.DF_DOUBLES);
        if (mf == null) {
            throw new MLContextException("DataFrame format not recognized as an accepted SystemDS MatrixFormat");
        }
        matrixMetadata.setMatrixFormat(mf);
    }

    public static void determineFrameFormatIfNeeded(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        FrameFormat frameFormat = frameMetadata.getFrameFormat();
        if (frameFormat != null) {
            return;
        }
        StructType schema = dataFrame.schema();
        boolean hasID = false;
        try {
            schema.fieldIndex("__INDEX");
            hasID = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FrameFormat ff = hasID ? FrameFormat.DF_WITH_INDEX : FrameFormat.DF;
        frameMetadata.setFrameFormat(ff);
    }

    public static boolean isDataFrameWithIDColumn(MatrixMetadata matrixMetadata) {
        return matrixMetadata != null && matrixMetadata.getMatrixFormat() != null && matrixMetadata.getMatrixFormat().hasIDColumn();
    }

    public static boolean isDataFrameWithIDColumn(FrameMetadata frameMetadata) {
        return frameMetadata != null && frameMetadata.getFrameFormat() != null && frameMetadata.getFrameFormat().hasIDColumn();
    }

    public static boolean isVectorBasedDataFrame(MatrixMetadata matrixMetadata) {
        return matrixMetadata != null && matrixMetadata.getMatrixFormat() != null && matrixMetadata.getMatrixFormat().isVectorBased();
    }

    public static MatrixObject javaRDDStringCSVToMatrixObject(JavaRDD<String> javaRDD) {
        return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(javaRDD, null);
    }

    public static MatrixObject javaRDDStringCSVToMatrixObject(JavaRDD<String> javaRDD, MatrixMetadata matrixMetadata) {
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        MatrixObject matrixObject = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.CSV));
        JavaPairRDD javaPairRDD2 = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        matrixObject.setRDDHandle(new RDDObject(javaPairRDD2));
        return matrixObject;
    }

    public static FrameObject javaRDDStringCSVToFrameObject(JavaRDD<String> javaRDD) {
        return MLContextConversionUtil.javaRDDStringCSVToFrameObject(javaRDD, null);
    }

    public static FrameObject javaRDDStringCSVToFrameObject(JavaRDD<String> javaRDD, FrameMetadata frameMetadata) {
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD javaPairRDDText = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY), frameMetadata.getFrameSchema().getSchema().toArray(new Types.ValueType[0]));
        JavaPairRDD<Long, FrameBlock> rdd = FrameRDDConverterUtils.csvToBinaryBlock(MLContextConversionUtil.jsc(), (JavaPairRDD<LongWritable, Text>)javaPairRDDText, (DataCharacteristics)mc, frameObject.getSchema(), false, ",", false, -1.0, null);
        frameObject.setRDDHandle(new RDDObject(rdd));
        return frameObject;
    }

    public static MatrixObject javaRDDStringIJVToMatrixObject(JavaRDD<String> javaRDD, MatrixMetadata matrixMetadata) {
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        MatrixObject matrixObject = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.TEXT));
        JavaPairRDD javaPairRDD2 = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        matrixObject.setRDDHandle(new RDDObject(javaPairRDD2));
        return matrixObject;
    }

    public static FrameObject javaRDDStringIJVToFrameObject(JavaRDD<String> javaRDD, FrameMetadata frameMetadata) {
        JavaPairRDD<Long, FrameBlock> rdd;
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD javaPairRDDText = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY), frameMetadata.getFrameSchema().getSchema().toArray(new Types.ValueType[0]));
        try {
            Types.ValueType[] lschema = UtilFunctions.nCopies((int)mc.getCols(), Types.ValueType.STRING);
            rdd = FrameRDDConverterUtils.textCellToBinaryBlock(MLContextConversionUtil.jsc(), (JavaPairRDD<LongWritable, Text>)javaPairRDDText, mc, lschema);
        }
        catch (DMLRuntimeException e) {
            e.printStackTrace();
            return null;
        }
        frameObject.setRDDHandle(new RDDObject(rdd));
        return frameObject;
    }

    public static MatrixObject rddStringCSVToMatrixObject(RDD<String> rdd) {
        return MLContextConversionUtil.rddStringCSVToMatrixObject(rdd, null);
    }

    public static MatrixObject rddStringCSVToMatrixObject(RDD<String> rdd, MatrixMetadata matrixMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringCSVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
    }

    public static FrameObject rddStringCSVToFrameObject(RDD<String> rdd) {
        return MLContextConversionUtil.rddStringCSVToFrameObject(rdd, null);
    }

    public static FrameObject rddStringCSVToFrameObject(RDD<String> rdd, FrameMetadata frameMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringCSVToFrameObject((JavaRDD<String>)javaRDD, frameMetadata);
    }

    public static MatrixObject rddStringIJVToMatrixObject(RDD<String> rdd, MatrixMetadata matrixMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringIJVToMatrixObject((JavaRDD<String>)javaRDD, matrixMetadata);
    }

    public static FrameObject rddStringIJVToFrameObject(RDD<String> rdd, FrameMetadata frameMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringIJVToFrameObject((JavaRDD<String>)javaRDD, frameMetadata);
    }

    public static JavaRDD<String> matrixObjectToJavaRDDStringCSV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringCSV(matrixObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> frameObjectToJavaRDDStringCSV(FrameObject frameObject, String delimiter) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringCSV(frameObject, delimiter);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> matrixObjectToJavaRDDStringIJV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringIJV(matrixObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> frameObjectToJavaRDDStringIJV(FrameObject frameObject) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringIJV(frameObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static RDD<String> matrixObjectToRDDStringIJV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringIJV(matrixObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> frameObjectToRDDStringIJV(FrameObject frameObject) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringIJV(frameObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> matrixObjectToRDDStringCSV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringCSV(matrixObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> frameObjectToRDDStringCSV(FrameObject frameObject, String delimiter) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringCSV(frameObject, delimiter);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static List<String> matrixObjectToListStringCSV(MatrixObject matrixObject) {
        MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        ArrayList<String> list = new ArrayList<String>();
        if (!mb.isEmptyBlock(false)) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                int prevCellRow = -1;
                StringBuilder sb = null;
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    int i = cell.getI();
                    double v = cell.getV();
                    if (i > prevCellRow) {
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            list.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        sb.append(v);
                        prevCellRow = i;
                        continue;
                    }
                    if (i != prevCellRow) continue;
                    sb.append(",");
                    sb.append(v);
                }
                if (sb != null) {
                    list.add(sb.toString());
                }
            } else {
                DenseBlock d = mb.getDenseBlock();
                for (int i = 0; i < rows; ++i) {
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < cols; ++j) {
                        if (j > 0) {
                            sb.append(",");
                        }
                        sb.append(d.get(i, j));
                    }
                    list.add(sb.toString());
                }
            }
        }
        matrixObject.release();
        return list;
    }

    public static List<String> frameObjectToListStringCSV(FrameObject frameObject, String delimiter) {
        FrameBlock fb = (FrameBlock)frameObject.acquireRead();
        int rows = fb.getNumRows();
        int cols = fb.getNumColumns();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rows; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    sb.append(delimiter);
                }
                if (fb.get(i, j) == null) continue;
                sb.append(fb.get(i, j));
            }
            list.add(sb.toString());
        }
        frameObject.release();
        return list;
    }

    public static List<String> matrixObjectToListStringIJV(MatrixObject matrixObject) {
        MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        ArrayList<String> list = new ArrayList<String>();
        if (mb.getNonZeros() > 0L) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                StringBuilder sb = null;
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    sb = new StringBuilder();
                    sb.append(cell.getI() + 1);
                    sb.append(" ");
                    sb.append(cell.getJ() + 1);
                    sb.append(" ");
                    sb.append(cell.getV());
                    list.add(sb.toString());
                }
            } else {
                StringBuilder sb = null;
                DenseBlock d = mb.getDenseBlock();
                for (int i = 0; i < rows; ++i) {
                    sb = new StringBuilder();
                    for (int j = 0; j < cols; ++j) {
                        sb = new StringBuilder();
                        sb.append(i + 1);
                        sb.append(" ");
                        sb.append(j + 1);
                        sb.append(" ");
                        sb.append(d.get(i, j));
                        list.add(sb.toString());
                    }
                }
            }
        }
        matrixObject.release();
        return list;
    }

    public static List<String> frameObjectToListStringIJV(FrameObject frameObject) {
        FrameBlock fb = (FrameBlock)frameObject.acquireRead();
        int rows = fb.getNumRows();
        int cols = fb.getNumColumns();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = null;
        for (int i = 0; i < rows; ++i) {
            sb = new StringBuilder();
            for (int j = 0; j < cols; ++j) {
                if (fb.get(i, j) == null) continue;
                sb = new StringBuilder();
                sb.append(i + 1);
                sb.append(" ");
                sb.append(j + 1);
                sb.append(" ");
                sb.append(fb.get(i, j));
                list.add(sb.toString());
            }
        }
        frameObject.release();
        return list;
    }

    public static double[][] matrixObjectTo2DDoubleArray(MatrixObject matrixObject) {
        MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
        double[][] matrix = DataConverter.convertToDoubleMatrix(mb);
        matrixObject.release();
        return matrix;
    }

    public static Dataset<Row> matrixObjectToDataFrame(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext, boolean isVectorDF) {
        try {
            JavaPairRDD<?, ?> binaryBlocks = sparkExecutionContext.getRDDHandleForMatrixObject(matrixObject, Types.FileFormat.BINARY);
            DataCharacteristics mc = matrixObject.getDataCharacteristics();
            return RDDConverterUtils.binaryBlockToDataFrame(MLContextConversionUtil.spark(), binaryBlocks, mc, isVectorDF);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting matrix object to DataFrame", e);
        }
    }

    public static Dataset<Row> frameObjectToDataFrame(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlockFrame = sparkExecutionContext.getRDDHandleForFrameObject(frameObject, Types.FileFormat.BINARY);
            DataCharacteristics mc = frameObject.getDataCharacteristics();
            return FrameRDDConverterUtils.binaryBlockToDataFrame(MLContextConversionUtil.spark(), binaryBlockFrame, mc, frameObject.getSchema());
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting frame object to DataFrame", e);
        }
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> matrixObjectToBinaryBlocks(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlocks = sparkExecutionContext.getRDDHandleForMatrixObject(matrixObject, Types.FileFormat.BINARY);
            return binaryBlocks;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting matrix object to binary blocks", e);
        }
    }

    public static JavaPairRDD<Long, FrameBlock> frameObjectToBinaryBlocks(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlocks = sparkExecutionContext.getRDDHandleForFrameObject(frameObject, Types.FileFormat.BINARY);
            return binaryBlocks;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting frame object to binary blocks", e);
        }
    }

    public static String[][] frameObjectTo2DStringArray(FrameObject frameObject) {
        FrameBlock fb = (FrameBlock)frameObject.acquireRead();
        String[][] frame = DataConverter.convertToStringFrame(fb);
        frameObject.release();
        return frame;
    }

    public static JavaSparkContext jsc() {
        return MLContextUtil.getJavaSparkContextFromProxy();
    }

    public static SparkContext sc() {
        return MLContextUtil.getSparkContextFromProxy();
    }

    public static SparkSession spark() {
        return MLContextUtil.getSparkSessionFromProxy();
    }
}

