/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.Nary;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class CSVReBlock
extends Lop {
    public static final String OPCODE = Opcodes.CSVRBLK.toString();
    private int _blocksize;

    public CSVReBlock(Lop input, int blen, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.CSVReBlock, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._blocksize = blen;
        if (et != Types.ExecType.SPARK) {
            throw new LopsException("Incorrect execution type for CSVReblock:" + et);
        }
        this.lps.setProperties(this.inputs, Types.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return "CSVReblock - blocksize = " + this._blocksize;
    }

    private String prepCSVProperties() {
        StringBuilder sb = new StringBuilder();
        Data dataInput = (Data)this.getInputs().get(0);
        Lop headerLop = dataInput.getNamedInputLop("header", String.valueOf(false));
        Lop delimLop = dataInput.getNamedInputLop("sep", ",");
        Lop fillLop = dataInput.getNamedInputLop("fill", String.valueOf(true));
        Lop fillValueLop = dataInput.getNamedInputLop("default", String.valueOf(0.0));
        Lop naStrings = dataInput.getNamedInputLop("naStrings", String.valueOf(""));
        if (headerLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter header must be a literal.");
        }
        if (delimLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter sep must be a literal.");
        }
        if (fillLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter fill must be a literal.");
        }
        if (fillValueLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter default must be a literal.");
        }
        sb.append(((Data)headerLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)delimLop).getStringValue());
        sb.append("\u00b0");
        sb.append(((Data)fillLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)fillValueLop).getDoubleValue());
        sb.append("\u00b0");
        if (naStrings instanceof Nary) {
            Nary naLops = (Nary)naStrings;
            for (Lop na : naLops.getInputs()) {
                sb.append(((Data)na).getStringValue());
                sb.append("\u00b7");
            }
        } else if (naStrings instanceof Data) {
            sb.append(((Data)naStrings).getStringValue());
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.prepOutputOperand(output), String.valueOf(this._blocksize), this.prepCSVProperties());
    }
}

