/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.hops.ipa.IPAPassApplyStaticAndDynamicHopRewrites;
import org.apache.sysds.hops.ipa.IPAPassCompressionWorkloadAnalysis;
import org.apache.sysds.hops.ipa.IPAPassEliminateDeadCode;
import org.apache.sysds.hops.ipa.IPAPassFlagFunctionsRecompileOnce;
import org.apache.sysds.hops.ipa.IPAPassFlagNonDeterminism;
import org.apache.sysds.hops.ipa.IPAPassForwardFunctionCalls;
import org.apache.sysds.hops.ipa.IPAPassInlineFunctions;
import org.apache.sysds.hops.ipa.IPAPassPropagateReplaceLiterals;
import org.apache.sysds.hops.ipa.IPAPassRemoveConstantBinaryOps;
import org.apache.sysds.hops.ipa.IPAPassRemoveUnnecessaryCheckpoints;
import org.apache.sysds.hops.ipa.IPAPassRemoveUnusedFunctions;
import org.apache.sysds.hops.ipa.IPAPassReplaceEvalFunctionCalls;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.hops.rewrite.IPAPassRewriteFederatedPlan;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DMLTranslator;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.utils.Explain;

public class InterProceduralAnalysis {
    private static final boolean LDEBUG = false;
    private static final Log LOG = LogFactory.getLog((String)InterProceduralAnalysis.class.getName());
    protected static final boolean INTRA_PROCEDURAL_ANALYSIS = true;
    protected static final boolean PROPAGATE_KNOWN_UDF_STATISTICS = true;
    protected static final boolean ALLOW_MULTIPLE_FUNCTION_CALLS = true;
    protected static final boolean REMOVE_UNUSED_FUNCTIONS = true;
    protected static final boolean FLAG_FUNCTION_RECOMPILE_ONCE = true;
    protected static final boolean REMOVE_UNNECESSARY_CHECKPOINTS = true;
    protected static final boolean REMOVE_CONSTANT_BINARY_OPS = true;
    protected static final boolean PROPAGATE_SCALAR_VARS_INTO_FUN = true;
    protected static final boolean PROPAGATE_SCALAR_LITERALS = true;
    protected static final boolean APPLY_STATIC_REWRITES = true;
    protected static final boolean APPLY_DYNAMIC_REWRITES = true;
    protected static final int INLINING_MAX_NUM_OPS = 10;
    protected static final boolean ELIMINATE_DEAD_CODE = true;
    protected static final boolean FORWARD_SIMPLE_FUN_CALLS = true;
    protected static final boolean FLAG_NONDETERMINISM = true;
    private final DMLProgram _prog;
    private final StatementBlock _sb;
    private FunctionCallGraph _fgraph;
    private final ArrayList<IPAPass> _passes;

    public InterProceduralAnalysis(DMLProgram dmlp) {
        this._prog = dmlp;
        this._sb = null;
        this._fgraph = new FunctionCallGraph(dmlp);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("IPA: Initial FunctionCallGraph: \n--MAIN PROGRAM\n" + Explain.explainFunctionCallGraph(this._fgraph, new HashSet<String>(), null, 1)));
        }
        this._passes = new ArrayList();
        this._passes.add(new IPAPassRemoveUnusedFunctions());
        this._passes.add(new IPAPassFlagFunctionsRecompileOnce());
        this._passes.add(new IPAPassRemoveUnnecessaryCheckpoints());
        this._passes.add(new IPAPassRemoveConstantBinaryOps());
        this._passes.add(new IPAPassPropagateReplaceLiterals());
        this._passes.add(new IPAPassInlineFunctions());
        this._passes.add(new IPAPassReplaceEvalFunctionCalls());
        this._passes.add(new IPAPassEliminateDeadCode());
        this._passes.add(new IPAPassFlagNonDeterminism());
        this._passes.add(new IPAPassForwardFunctionCalls());
        this._passes.add(new IPAPassApplyStaticAndDynamicHopRewrites());
    }

    public InterProceduralAnalysis(StatementBlock sb) {
        this._prog = sb.getDMLProg();
        this._sb = sb;
        this._fgraph = new FunctionCallGraph(sb);
        this._passes = new ArrayList();
    }

    public void analyzeProgram() {
        this.analyzeProgram(1);
    }

    public void analyzeProgram(int repetitions) {
        if (repetitions <= 0) {
            throw new HopsException("Invalid number of IPA repetitions: " + repetitions);
        }
        FunctionCallSizeInfo lastSizes = null;
        for (int i = 0; i < repetitions; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: start IPA iteration " + (i + 1) + "/" + repetitions + "."));
            }
            FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: Initial FunctionCallSummary: \n" + fcallSizes));
            }
            if (this._fgraph.containsSecondOrderCall() && i == 0) {
                this._prog.copyOriginalFunctions();
            }
            for (String string : fcallSizes.getInvalidFunctions()) {
                if (this._fgraph.isRecursiveFunction(string) || !this.isUnarySizePreservingFunction(this._prog.getFunctionStatementBlock(string))) continue;
                fcallSizes.addDimsPreservingFunction(string);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: Extended FunctionCallSummary: \n" + fcallSizes));
            }
            LocalVariableMap callVars = new LocalVariableMap();
            for (StatementBlock sb : this._prog.getStatementBlocks()) {
                this.propagateStatisticsAcrossBlock(sb, callVars, fcallSizes, new HashSet<String>(), true);
            }
            boolean rebuildFGraph = false;
            for (IPAPass pass : this._passes) {
                if (!pass.isApplicable(this._fgraph)) continue;
                rebuildFGraph |= pass.rewriteProgram(this._prog, this._fgraph, fcallSizes);
            }
            if (this._fgraph.getReachableFunctions().isEmpty() || lastSizes != null && lastSizes.equals(fcallSizes)) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("IPA: Early abort after " + (i + 1) + "/" + repetitions + " repetitions due to reached fixpoint."));
                break;
            }
            if (!rebuildFGraph || i >= repetitions - 1) continue;
            this._fgraph = new FunctionCallGraph(this._prog);
        }
        FunctionCallGraph graph2 = new FunctionCallGraph(this._prog);
        List<IPAPass> fpasses = Arrays.asList(new IPAPassRemoveUnusedFunctions(), new IPAPassCompressionWorkloadAnalysis(), new IPAPassApplyStaticAndDynamicHopRewrites(), new IPAPassRewriteFederatedPlan());
        for (IPAPass iPAPass : fpasses) {
            if (!iPAPass.isApplicable(graph2)) continue;
            iPAPass.rewriteProgram(this._prog, graph2, null);
        }
    }

    public Set<String> analyzeSubProgram() {
        DMLTranslator.resetHopsDAGVisitStatus(this._sb);
        FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph);
        if (!fcallSizes.getValidFunctions().isEmpty()) {
            LocalVariableMap callVars = new LocalVariableMap();
            this.propagateStatisticsAcrossBlock(this._sb, callVars, fcallSizes, new HashSet<String>(), true);
        }
        return fcallSizes.getValidFunctions();
    }

    private boolean isUnarySizePreservingFunction(FunctionStatementBlock fsb) {
        boolean ret;
        FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
        boolean bl = ret = fstmt.getInputParams().size() == 1 && fstmt.getInputParams().get(0).getDataType() == Types.DataType.MATRIX && fstmt.getOutputParams().size() == 1 && fstmt.getOutputParams().get(0).getDataType() == Types.DataType.MATRIX;
        if (ret) {
            FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph, false);
            HashSet<String> fnStack = new HashSet<String>();
            LocalVariableMap callVars = new LocalVariableMap();
            MatrixObject mo = InterProceduralAnalysis.createOutputMatrix(7777L, 3333L, -1L);
            callVars.put(fstmt.getInputParams().get(0).getName(), mo);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, false);
            }
            MatrixObject mo2 = (MatrixObject)callVars.get(fstmt.getOutputParams().get(0).getName());
            ret &= mo.getNumRows() == mo2.getNumRows() && mo.getNumColumns() == mo2.getNumColumns();
            mo.getDataCharacteristics().setDimension(-1L, -1L);
            callVars.put(fstmt.getInputParams().get(0).getName(), mo);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, false);
            }
        }
        return ret;
    }

    private void propagateStatisticsAcrossBlock(StatementBlock sb, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack, boolean replaceScalars) {
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, wsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : wstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)wsb)) {
                InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
                for (StatementBlock sbi : wstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(isb.getPredicateHops(), callVars);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            LocalVariableMap callVarsElse = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : istmt.getIfBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
            }
            for (StatementBlock sbi : istmt.getElseBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVarsElse, fcallSizes, fnStack, replaceScalars);
            }
            callVars = Recompiler.reconcileUpdatedCallVarsIf(oldCallVars, callVars, callVarsElse, (StatementBlock)isb);
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getFromHops(), callVars);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getToHops(), callVars);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getIncrementHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, fsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)fsb)) {
                for (StatementBlock sbi : fstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack, replaceScalars);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else {
            Recompiler.removeUpdatedScalars(callVars, sb);
            ArrayList<Hop> roots = sb.getHops();
            DMLProgram prog = sb.getDMLProg();
            if (replaceScalars) {
                Hop.resetVisitStatus(roots);
                InterProceduralAnalysis.propagateScalarsAcrossDAG(roots, callVars);
            }
            Hop.resetVisitStatus(roots);
            InterProceduralAnalysis.propagateStatisticsAcrossDAG(roots, callVars);
            Hop.resetVisitStatus(roots);
            this.propagateStatisticsIntoFunctions(prog, roots, callVars, fcallSizes, fnStack, replaceScalars);
        }
    }

    private static void propagateScalarsAcrossDAG(ArrayList<Hop> roots, LocalVariableMap vars) {
        for (Hop hop : roots) {
            try {
                Recompiler.rReplaceLiterals(hop, vars, true);
            }
            catch (Exception ex) {
                throw new HopsException("Failed to perform scalar literal replacement.", ex);
            }
        }
    }

    private static void propagateStatisticsAcrossPredicateDAG(Hop root, LocalVariableMap vars) {
        if (root == null) {
            return;
        }
        root.resetVisitStatus();
        try {
            Recompiler.rUpdateStatistics(root, vars);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private static void propagateStatisticsAcrossDAG(ArrayList<Hop> roots, LocalVariableMap vars) {
        if (roots == null) {
            return;
        }
        try {
            for (Hop hop : roots) {
                Recompiler.rUpdateStatistics(hop, vars);
            }
            Recompiler.extractDAGOutputStatistics(roots, vars, true);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, ArrayList<Hop> roots, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack, boolean replaceScalars) {
        for (Hop root : roots) {
            this.propagateStatisticsIntoFunctions(prog, root, callVars, fcallSizes, fnStack, replaceScalars);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, Hop hop, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack, boolean replaceScalars) {
        if (hop.isVisited()) {
            return;
        }
        for (Hop c : hop.getInput()) {
            this.propagateStatisticsIntoFunctions(prog, c, callVars, fcallSizes, fnStack, replaceScalars);
        }
        if (hop instanceof FunctionOp) {
            FunctionOp fop = (FunctionOp)hop;
            String fkey = fop.getFunctionKey();
            if (fop.getFunctionType() == FunctionOp.FunctionType.DML) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                if (fcallSizes.isValidFunction(fkey) && !fnStack.contains(fkey)) {
                    fnStack.add(fkey);
                    LocalVariableMap tmpVars = new LocalVariableMap();
                    InterProceduralAnalysis.populateLocalVariableMapForFunctionCall(fstmt, fop, callVars, tmpVars, fcallSizes);
                    this.propagateStatisticsAcrossBlock(fsb, tmpVars, fcallSizes, fnStack, replaceScalars);
                    InterProceduralAnalysis.extractFunctionCallReturnStatistics(fstmt, fop, tmpVars, callVars, true);
                    fnStack.remove(fkey);
                } else if (fcallSizes.isDimsPreservingFunction(fkey)) {
                    InterProceduralAnalysis.extractFunctionCallEquivalentReturnStatistics(fstmt, fop, callVars);
                } else {
                    InterProceduralAnalysis.extractFunctionCallUnknownReturnStatistics(fstmt, fop, callVars);
                }
            }
        }
        hop.setVisited();
    }

    private static void populateLocalVariableMapForFunctionCall(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callvars, LocalVariableMap vars, FunctionCallSizeInfo fcallSizes) {
        String[] funArgNames = fop.getInputVariableNames();
        ArrayList<Hop> inputOps = fop.getInput();
        String fkey = fop.getFunctionKey();
        for (int i = 0; i < Math.min(inputOps.size(), funArgNames.length); ++i) {
            Data scalar;
            DataIdentifier dat = fstmt.getInputParam(funArgNames[i]);
            if (dat == null) {
                throw new HopsException("Failed IPA: function argument '" + funArgNames[i] + "' does not exist in function signature of " + fop.getFunctionKey() + ".");
            }
            Hop input = inputOps.get(i);
            if (input.getDataType() == Types.DataType.MATRIX) {
                MatrixObject mo = new MatrixObject(Types.ValueType.FP64, null);
                MatrixCharacteristics mc = new MatrixCharacteristics(input.getDim1(), input.getDim2(), ConfigurationManager.getBlocksize(), fcallSizes.isSafeNnz(fkey, i) ? input.getNnz() : -1L);
                MetaDataFormat meta = new MetaDataFormat(mc, null);
                mo.setMetaData(meta);
                vars.put(dat.getName(), mo);
                continue;
            }
            if (input.getDataType() != Types.DataType.SCALAR) continue;
            if (input instanceof LiteralOp) {
                vars.put(dat.getName(), ScalarObjectFactory.createScalarObject(input.getValueType(), (LiteralOp)input));
                continue;
            }
            if (fcallSizes.getFunctionCallCount(fkey) != 1 || !(input instanceof DataOp) || (scalar = callvars.get(input.getName())) == null || !(scalar instanceof ScalarObject)) continue;
            vars.put(dat.getName(), scalar);
        }
    }

    private static void extractFunctionCallReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap tmpVars, LocalVariableMap callVars, boolean overwrite) {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = fop.getFunctionKey();
        try {
            for (int i = 0; i < foutputOps.size() && outputVars.length > i; ++i) {
                Types.DataType pdataType;
                Types.DataType fdataType;
                DataIdentifier di = foutputOps.get(i);
                String fvarname = di.getName();
                String pvarname = outputVars[i];
                if (callVars.keySet().contains(pvarname) && (fdataType = di.getDataType()) != (pdataType = callVars.get(pvarname).getDataType())) {
                    callVars.remove(pvarname);
                }
                if (di.getDataType() != Types.DataType.MATRIX || !tmpVars.keySet().contains(fvarname)) continue;
                MatrixObject moIn = (MatrixObject)tmpVars.get(fvarname);
                if (!callVars.keySet().contains(pvarname) || overwrite) {
                    MatrixObject moOut = InterProceduralAnalysis.createOutputMatrix(moIn.getNumRows(), moIn.getNumColumns(), moIn.getNnz());
                    callVars.put(pvarname, moOut);
                    continue;
                }
                Data dat = callVars.get(pvarname);
                if (!(dat instanceof MatrixObject)) continue;
                MatrixObject moOut = (MatrixObject)dat;
                DataCharacteristics dc = moOut.getDataCharacteristics();
                if (OptimizerUtils.estimateSizeExactSparsity(dc.getRows(), dc.getCols(), dc.getNonZeros() > 0L ? OptimizerUtils.getSparsity(dc) : 1.0) >= OptimizerUtils.estimateSize(moIn.getNumRows(), moIn.getNumColumns())) continue;
                dc.setDimension(moIn.getNumRows(), moIn.getNumColumns());
                dc.setNonZeros(moIn.getNnz());
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private static void extractFunctionCallUnknownReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = fop.getFunctionKey();
        try {
            int olen = Math.min(foutputOps.size(), outputVars.length);
            for (int i = 0; i < olen; ++i) {
                DataIdentifier di = foutputOps.get(i);
                String pvarname = outputVars[i];
                if (di.getDataType() != Types.DataType.MATRIX) continue;
                callVars.put(pvarname, InterProceduralAnalysis.createOutputMatrix(-1L, -1L, -1L));
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private static void extractFunctionCallEquivalentReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) {
        try {
            Hop input = fop.getInput().get(0);
            MatrixObject moOut = InterProceduralAnalysis.createOutputMatrix(input.getDim1(), input.getDim2(), -1L);
            callVars.put(fop.getOutputVariableNames()[0], moOut);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics for unary function " + fop.getFunctionKey() + ".", ex);
        }
    }

    private static MatrixObject createOutputMatrix(long dim1, long dim2, long nnz) {
        MatrixObject moOut = new MatrixObject(Types.ValueType.FP64, null);
        MatrixCharacteristics mc = new MatrixCharacteristics(dim1, dim2, ConfigurationManager.getBlocksize(), nnz);
        MetaDataFormat meta = new MetaDataFormat(mc, null);
        moOut.setMetaData(meta);
        return moOut;
    }
}

