/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockCommand
extends DatanodeCommand {
    public static final long NO_ACK = Long.MAX_VALUE;
    final String poolId;
    final Block[] blocks;
    final DatanodeInfo[][] targets;
    final StorageType[][] targetStorageTypes;
    final String[][] targetStorageIDs;
    private static final DatanodeInfo[][] EMPTY_TARGET_DATANODES = new DatanodeInfo[0][];
    private static final StorageType[][] EMPTY_TARGET_STORAGE_TYPES = new StorageType[0][];
    private static final String[][] EMPTY_TARGET_STORAGEIDS = new String[0][];

    public BlockCommand(int action, String poolId, List<DatanodeDescriptor.BlockTargetPair> blocktargetlist) {
        super(action);
        this.poolId = poolId;
        this.blocks = new Block[blocktargetlist.size()];
        this.targets = new DatanodeInfo[this.blocks.length][];
        this.targetStorageTypes = new StorageType[this.blocks.length][];
        this.targetStorageIDs = new String[this.blocks.length][];
        for (int i = 0; i < this.blocks.length; ++i) {
            DatanodeDescriptor.BlockTargetPair p = blocktargetlist.get(i);
            this.blocks[i] = p.block;
            this.targets[i] = DatanodeStorageInfo.toDatanodeInfos(p.targets);
            this.targetStorageTypes[i] = DatanodeStorageInfo.toStorageTypes(p.targets);
            this.targetStorageIDs[i] = DatanodeStorageInfo.toStorageIDs(p.targets);
        }
    }

    public BlockCommand(int action, String poolId, Block[] blocks) {
        this(action, poolId, blocks, EMPTY_TARGET_DATANODES, EMPTY_TARGET_STORAGE_TYPES, EMPTY_TARGET_STORAGEIDS);
    }

    public BlockCommand(int action, String poolId, Block[] blocks, DatanodeInfo[][] targets, StorageType[][] targetStorageTypes, String[][] targetStorageIDs) {
        super(action);
        this.poolId = poolId;
        this.blocks = blocks;
        this.targets = targets;
        this.targetStorageTypes = targetStorageTypes;
        this.targetStorageIDs = targetStorageIDs;
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public DatanodeInfo[][] getTargets() {
        return this.targets;
    }

    public StorageType[][] getTargetStorageTypes() {
        return this.targetStorageTypes;
    }

    public String[][] getTargetStorageIDs() {
        return this.targetStorageIDs;
    }
}

