/*
 * Decompiled with CFR 0.152.
 */
package jcuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import jcuda.NativePointerObject;

public class Pointer
extends NativePointerObject {
    private long byteOffset;
    private Buffer buffer;
    private NativePointerObject[] pointers;

    public static Pointer to(byte[] values) {
        return new Pointer(ByteBuffer.wrap(values));
    }

    public static Pointer to(char[] values) {
        return new Pointer(CharBuffer.wrap(values));
    }

    public static Pointer to(short[] values) {
        return new Pointer(ShortBuffer.wrap(values));
    }

    public static Pointer to(int[] values) {
        return new Pointer(IntBuffer.wrap(values));
    }

    public static Pointer to(float[] values) {
        return new Pointer(FloatBuffer.wrap(values));
    }

    public static Pointer to(long[] values) {
        return new Pointer(LongBuffer.wrap(values));
    }

    public static Pointer to(double[] values) {
        return new Pointer(DoubleBuffer.wrap(values));
    }

    public static Pointer to(Buffer buffer) {
        if (buffer == null || !buffer.isDirect() && !buffer.hasArray()) {
            throw new IllegalArgumentException("Buffer may not be null and must have an array or be direct");
        }
        return new Pointer(buffer);
    }

    public static Pointer toBuffer(Buffer buffer) {
        if (buffer == null || !buffer.isDirect() && !buffer.hasArray()) {
            throw new IllegalArgumentException("Buffer may not be null and must have an array or be direct");
        }
        if (buffer instanceof ByteBuffer) {
            return Pointer.computePointer((ByteBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return Pointer.computePointer((ShortBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return Pointer.computePointer((IntBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return Pointer.computePointer((LongBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return Pointer.computePointer((FloatBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return Pointer.computePointer((DoubleBuffer)buffer);
        }
        throw new IllegalArgumentException("Unknown buffer type: " + buffer);
    }

    private static Pointer computePointer(ByteBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 1);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            ByteBuffer t = ByteBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 1);
        }
        return result;
    }

    private static Pointer computePointer(ShortBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 2);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            ShortBuffer t = ShortBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 2);
        }
        return result;
    }

    private static Pointer computePointer(IntBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 4);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            IntBuffer t = IntBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 4);
        }
        return result;
    }

    private static Pointer computePointer(LongBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 8);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            LongBuffer t = LongBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 8);
        }
        return result;
    }

    private static Pointer computePointer(FloatBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 4);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            FloatBuffer t = FloatBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 4);
        }
        return result;
    }

    private static Pointer computePointer(DoubleBuffer buffer) {
        Pointer result = null;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 8);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            DoubleBuffer t = DoubleBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 8);
        }
        return result;
    }

    public static Pointer to(NativePointerObject ... pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(pointers);
    }

    public Pointer() {
        this.buffer = null;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    protected Pointer(long nativePointerValue) {
        super(nativePointerValue);
        this.buffer = null;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    private Pointer(Buffer buffer) {
        this.buffer = buffer;
        this.pointers = null;
        this.byteOffset = 0L;
    }

    private Pointer(NativePointerObject[] pointers) {
        this.buffer = null;
        this.pointers = pointers;
        this.byteOffset = 0L;
    }

    protected Pointer(Pointer other) {
        super(other.getNativePointer());
        this.buffer = other.buffer;
        this.pointers = other.pointers;
        this.byteOffset = other.byteOffset;
    }

    protected Pointer(Pointer other, long byteOffset) {
        this(other);
        this.byteOffset += byteOffset;
    }

    public Pointer withByteOffset(long byteOffset) {
        return new Pointer(this, byteOffset);
    }

    public ByteBuffer getByteBuffer(long byteOffset, long byteSize) {
        if (this.buffer == null) {
            return null;
        }
        if (!(this.buffer instanceof ByteBuffer)) {
            return null;
        }
        ByteBuffer internalByteBuffer = (ByteBuffer)this.buffer;
        ByteBuffer byteBuffer = internalByteBuffer.slice();
        byteBuffer.limit(Math.toIntExact(byteOffset + byteSize));
        byteBuffer.position(Math.toIntExact(byteOffset));
        return byteBuffer.slice().order(ByteOrder.nativeOrder());
    }

    public ByteBuffer getByteBuffer() {
        if (this.buffer == null) {
            return null;
        }
        if (!(this.buffer instanceof ByteBuffer)) {
            return null;
        }
        ByteBuffer internalByteBuffer = (ByteBuffer)this.buffer;
        ByteBuffer byteBuffer = internalByteBuffer.slice();
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    protected long getByteOffset() {
        return this.byteOffset;
    }

    @Override
    public String toString() {
        if (this.buffer != null) {
            return "Pointer[buffer=" + this.buffer + ",byteOffset=" + this.byteOffset + "]";
        }
        if (this.pointers != null) {
            return "Pointer[pointers=" + Arrays.toString(this.pointers) + ",byteOffset=" + this.byteOffset + "]";
        }
        return "Pointer[nativePointer=0x" + Long.toHexString(this.getNativePointer()) + ",byteOffset=" + this.byteOffset + "]";
    }
}

