/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.MemoryEstimates;

public final class ColGroupSizes {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupSizes.class.getName());

    public static long estimateInMemorySizeGroup(int nrColumns) {
        long size = 16L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(nrColumns));
        return size;
    }

    public static long estimateInMemorySizeGroupValue(int nrColumns, int nrValues, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
        size += 8L;
        size += 8L;
        ++size;
        ++size;
        size += 2L;
        size += 4L;
        return size += DictionaryFactory.getInMemorySize(nrValues, nrColumns, tupleSparsity, lossy);
    }

    public static long estimateInMemorySizeDDC(int nrCols, int numTuples, int dataLength, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrCols, numTuples, tupleSparsity, lossy);
        return size += MapToFactory.estimateInMemorySize(dataLength, numTuples);
    }

    public static long estimateInMemorySizeOffset(int nrColumns, int nrValues, int pointers, int offsetLength, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, nrValues, tupleSparsity, lossy);
        size = (long)((double)size + MemoryEstimates.intArrayCost(pointers));
        return size += MemoryEstimates.charArrayCost(offsetLength);
    }

    public static long estimateInMemorySizeOLE(int nrColumns, int nrValues, int offsetLength, int nrRows, double tupleSparsity, boolean lossy) {
        nrColumns = nrColumns > 0 ? nrColumns : 1;
        long size = ColGroupSizes.estimateInMemorySizeOffset(nrColumns, nrValues, nrValues + 1, offsetLength += nrRows / 65535 * 2, tupleSparsity, lossy);
        return size;
    }

    public static long estimateInMemorySizeRLE(int nrColumns, int nrValues, int nrRuns, int nrRows, double tupleSparsity, boolean lossy) {
        int offsetLength = nrRuns * 2;
        long size = ColGroupSizes.estimateInMemorySizeOffset(nrColumns, nrValues, nrValues + 1, offsetLength, tupleSparsity, lossy);
        return size;
    }

    public static long estimateInMemorySizeSDC(int nrColumns, int nrValues, int nrRows, int largestOff, boolean largestOffIsZero, boolean containNoZeroValues, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, nrValues + (largestOffIsZero || containNoZeroValues ? 0 : 1), tupleSparsity, lossy);
        size += OffsetFactory.estimateInMemorySize(nrRows - largestOff, nrRows);
        if (nrValues > 1) {
            size += MapToFactory.estimateInMemorySize(nrRows - largestOff, nrValues);
        }
        return size;
    }

    public static long estimateInMemorySizeSDCSingle(int nrColumns, int nrValues, int nrRows, int largestOff, boolean largestOffIsZero, boolean containNoZeroValues, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, nrValues + (largestOffIsZero || containNoZeroValues ? 0 : 1), tupleSparsity, lossy);
        return size += OffsetFactory.estimateInMemorySize(nrRows - largestOff, nrRows);
    }

    public static long estimateInMemorySizeCONST(int nrColumns, int nrValues, double tupleSparsity, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
        return size += DictionaryFactory.getInMemorySize(nrValues, nrColumns, tupleSparsity, lossy);
    }

    public static long estimateInMemorySizeEMPTY(int nrColumns) {
        return ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
    }

    public static long estimateInMemorySizeUncompressed(int nrRows, int nrColumns, double sparsity) {
        long size = 0L;
        size += ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
        size += 8L;
        return size += MatrixBlock.estimateSizeInMemory(nrRows, nrColumns, nrColumns > 1 ? sparsity : 1.0);
    }
}

