/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Interop;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataFileInteropTest {
    private static final File DATAFILE_DIR = new File(System.getProperty("test.dir", "/tmp"));

    @BeforeClass
    public static void printDir() {
        System.out.println("Reading data files from directory: " + DATAFILE_DIR.getAbsolutePath());
    }

    @Test
    public void testGeneratedGeneric() throws IOException {
        System.out.println("Reading with generic:");
        DatumReaderProvider<Object> provider = new DatumReaderProvider<Object>(){

            @Override
            public DatumReader<Object> get() {
                return new GenericDatumReader();
            }
        };
        this.readFiles(provider);
    }

    @Test
    public void testGeneratedSpecific() throws IOException {
        System.out.println("Reading with specific:");
        DatumReaderProvider<Interop> provider = new DatumReaderProvider<Interop>(){

            @Override
            public DatumReader<Interop> get() {
                return new SpecificDatumReader();
            }
        };
        this.readFiles(provider);
    }

    private <T> void readFiles(DatumReaderProvider<T> provider) throws IOException {
        for (File f : DATAFILE_DIR.listFiles()) {
            System.out.println("Reading: " + f.getName());
            FileReader reader = DataFileReader.openReader((File)f, provider.get());
            for (Object datum : reader) {
                Assert.assertNotNull(datum);
            }
        }
    }

    static interface DatumReaderProvider<T> {
        public DatumReader<T> get();
    }
}

