/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.LinkedList;
import java.util.List;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanStorage;
import org.apache.avro.ipc.trace.Util;

public class InMemorySpanStorage
implements SpanStorage {
    private static final long DEFAULT_MAX_SPANS = 10000L;
    protected LinkedList<Span> spans = new LinkedList();
    private long maxSpans = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpan(Span s) {
        LinkedList<Span> linkedList = this.spans;
        synchronized (linkedList) {
            this.spans.add(s);
            if ((long)this.spans.size() > this.maxSpans) {
                this.spans.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSpans(long maxSpans) {
        this.maxSpans = maxSpans;
        LinkedList<Span> linkedList = this.spans;
        synchronized (linkedList) {
            while ((long)this.spans.size() > maxSpans) {
                this.spans.removeFirst();
            }
        }
    }

    @Override
    public List<Span> getAllSpans() {
        return (LinkedList)this.spans.clone();
    }

    @Override
    public List<Span> getSpansInRange(long start, long end) {
        LinkedList<Span> out = new LinkedList<Span>();
        for (Span s : this.spans) {
            if (!Util.spanInRange(s, start, end)) continue;
            out.add(s);
        }
        return out;
    }
}

