/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.definition;

import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.KeyStoreType;
import org.apache.synapse.securevault.SecureVaultException;
import org.apache.synapse.securevault.keystore.CACertsLoader;
import org.apache.synapse.securevault.keystore.JKSKeyStoreLoader;
import org.apache.synapse.securevault.keystore.PKCS12KeyStoreLoader;
import org.apache.synapse.securevault.keystore.PKCS8KeyStoreLoader;
import org.apache.synapse.securevault.secret.SecretInformation;

public abstract class KeyStoreInformation {
    protected final Log log;
    public static final String KEY_STORE_CERTIFICATE_FILE_PATH = "keyStoreCertificateFilePath";
    public static final String ENABLE_HOST_NAME_VERIFIER = "enableHostnameVerifier";
    private KeyStoreType storeType;
    private String alias;
    private String location;
    private SecretInformation keyStorePasswordProvider;
    private String provider;
    private final Map<String, String> parameters = new HashMap<String, String>();

    protected KeyStoreInformation() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public void setStoreType(String storeType) {
        if ((storeType == null || "".equals(storeType)) && this.log.isDebugEnabled()) {
            this.log.debug((Object)"Given store type is null , using default type : JKS");
        }
        this.storeType = KeyStoreType.valueOf(storeType);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        if (alias == null || "".equals(alias)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Alias for a key entry or a certificate is null");
            }
            return;
        }
        this.alias = alias;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (location != null && "".equals(location)) {
            this.handleException("KeyStore location can not be null");
        }
        this.location = location;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setKeyStorePasswordProvider(SecretInformation keyStorePasswordProvider) {
        this.keyStorePasswordProvider = keyStorePasswordProvider;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected KeyStore getKeyStore() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading KeyStore with type : " + (Object)((Object)this.storeType)));
        }
        String keyStorePassword = this.keyStorePasswordProvider.getResolvedSecret();
        switch (this.storeType) {
            case JKS: {
                JKSKeyStoreLoader jksKeyStoreLoader = new JKSKeyStoreLoader(this.location, keyStorePassword);
                return jksKeyStoreLoader.getKeyStore();
            }
            case PKCS12: {
                PKCS12KeyStoreLoader pkcs12KeyStoreLoader = new PKCS12KeyStoreLoader(this.location, keyStorePassword);
                return pkcs12KeyStoreLoader.getKeyStore();
            }
            case PKCS8: {
                PKCS8KeyStoreLoader pkcs8KeyStoreLoader = new PKCS8KeyStoreLoader(this.location, this.parameters.get(KEY_STORE_CERTIFICATE_FILE_PATH), keyStorePassword, this.alias);
                return pkcs8KeyStoreLoader.getKeyStore();
            }
            case CA_CERTIFICATES_PATH: {
                CACertsLoader caCertsLoader = new CACertsLoader();
                return caCertsLoader.loadTrustStore(this.location);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"No KeyStore Found");
        }
        return null;
    }

    protected void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SecureVaultException(msg);
    }

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SecureVaultException(msg, e);
    }

    public SecretInformation getKeyStorePasswordProvider() {
        return this.keyStorePasswordProvider;
    }
}

