/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.xquery.MediatorBaseVariable;
import org.apache.synapse.mediators.xquery.MediatorCustomVariable;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.mediators.xquery.XQueryMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class XQueryMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator m) {
        List<MediatorVariable> list;
        List<MediatorProperty> pros;
        if (!(m instanceof XQueryMediator)) {
            this.handleException("Invalid Mediator has passed to serializer");
        }
        XQueryMediator queryMediator = (XQueryMediator)m;
        OMElement xquery = fac.createOMElement("xquery", synNS);
        Value key = queryMediator.getQueryKey();
        if (key != null) {
            ValueSerializer keySerializer = new ValueSerializer();
            keySerializer.serializeValue(key, "key", xquery);
        }
        XQueryMediatorSerializer.saveTracingState((OMElement)xquery, (Mediator)queryMediator);
        SynapseXPath targetXPath = queryMediator.getTarget();
        if (targetXPath != null && !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(targetXPath.toString())) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)targetXPath, (OMElement)xquery, (String)"target");
        }
        if ((pros = queryMediator.getDataSourceProperties()) != null && !pros.isEmpty()) {
            OMElement dataSource = fac.createOMElement("dataSource", synNS);
            this.serializeProperties(dataSource, pros);
            xquery.addChild((OMNode)dataSource);
        }
        if ((list = queryMediator.getVariables()) != null && !list.isEmpty()) {
            for (MediatorVariable o : list) {
                SynapseXPath expression;
                QName name;
                MediatorVariable variable;
                if (o instanceof MediatorBaseVariable) {
                    variable = (MediatorBaseVariable)o;
                    name = variable.getName();
                    Object value = variable.getValue();
                    if (name == null || value == null) continue;
                    OMElement baseElement = fac.createOMElement("variable", synNS);
                    baseElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                    baseElement.addAttribute(fac.createOMAttribute("value", nullNS, (String)value));
                    String type = null;
                    int varibelType = variable.getType();
                    if (13 == varibelType) {
                        type = "INT";
                    } else if (14 == varibelType) {
                        type = "INTEGER";
                    } else if (11 == varibelType) {
                        type = "BOOLEAN";
                    } else if (32 == varibelType) {
                        type = "BYTE";
                    } else if (19 == varibelType) {
                        type = "DOUBLE";
                    } else if (15 == varibelType) {
                        type = "SHORT";
                    } else if (16 == varibelType) {
                        type = "LONG";
                    } else if (21 == varibelType) {
                        type = "FLOAT";
                    } else if (30 == varibelType) {
                        type = "STRING";
                    } else if (4 == varibelType) {
                        type = "DOCUMENT";
                    } else if (5 == varibelType) {
                        type = "DOCUMENT_ELEMENT";
                    } else if (6 == varibelType) {
                        type = "ELEMENT";
                    } else {
                        this.handleException("Unknown Type " + varibelType);
                    }
                    if (type != null) {
                        baseElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                    }
                    xquery.addChild((OMNode)baseElement);
                    continue;
                }
                if (!(o instanceof MediatorCustomVariable) || (name = (variable = (MediatorCustomVariable)o).getName()) == null) continue;
                OMElement customElement = fac.createOMElement("variable", synNS);
                customElement.addAttribute(fac.createOMAttribute("name", nullNS, name.getLocalPart()));
                String regkey = ((MediatorCustomVariable)variable).getRegKey();
                if (regkey != null) {
                    customElement.addAttribute(fac.createOMAttribute("key", nullNS, regkey));
                }
                if ((expression = ((MediatorCustomVariable)variable).getExpression()) != null && !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(expression.toString())) {
                    SynapseXPathSerializer.serializeXPath((SynapseXPath)expression, (OMElement)customElement, (String)"expression");
                }
                String type = null;
                int varibelType = variable.getType();
                if (4 == varibelType) {
                    type = "DOCUMENT";
                } else if (5 == varibelType) {
                    type = "DOCUMENT_ELEMENT";
                } else if (6 == varibelType) {
                    type = "ELEMENT";
                } else if (13 == varibelType) {
                    type = "INT";
                } else if (14 == varibelType) {
                    type = "INTEGER";
                } else if (11 == varibelType) {
                    type = "BOOLEAN";
                } else if (32 == varibelType) {
                    type = "BYTE";
                } else if (19 == varibelType) {
                    type = "DOUBLE";
                } else if (15 == varibelType) {
                    type = "SHORT";
                } else if (16 == varibelType) {
                    type = "LONG";
                } else if (21 == varibelType) {
                    type = "FLOAT";
                } else if (30 == varibelType) {
                    type = "STRING";
                } else {
                    this.handleException("Unknown Type " + varibelType);
                }
                if (type != null) {
                    customElement.addAttribute(fac.createOMAttribute("type", nullNS, type));
                }
                xquery.addChild((OMNode)customElement);
            }
        }
        return xquery;
    }

    public String getMediatorClassName() {
        return XQueryMediator.class.getName();
    }
}

