/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message;

import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;

public class BaseMessageContext
implements MessageContext {
    private String communicationProfile;
    private XMLObject inboundMessage;
    private String inboundMessageIssuer;
    private InTransport inboundTransport;
    private XMLObject outboundMessage;
    private String outboundMessageIssuer;
    private OutTransport outboundTransport;
    private SecurityPolicyResolver securityPolicyResolver;
    private HandlerChainResolver preSecurityInboundHandlerChainResolver;
    private HandlerChainResolver postSecurityInboundHandlerChainResolver;
    private HandlerChainResolver outboundHandlerChainResolver;

    public String getCommunicationProfileId() {
        return this.communicationProfile;
    }

    public XMLObject getInboundMessage() {
        return this.inboundMessage;
    }

    public String getInboundMessageIssuer() {
        return this.inboundMessageIssuer;
    }

    public InTransport getInboundMessageTransport() {
        return this.inboundTransport;
    }

    public XMLObject getOutboundMessage() {
        return this.outboundMessage;
    }

    public String getOutboundMessageIssuer() {
        return this.outboundMessageIssuer;
    }

    public OutTransport getOutboundMessageTransport() {
        return this.outboundTransport;
    }

    public SecurityPolicyResolver getSecurityPolicyResolver() {
        return this.securityPolicyResolver;
    }

    public void setCommunicationProfileId(String id) {
        this.communicationProfile = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setInboundMessage(XMLObject message) {
        this.inboundMessage = message;
    }

    public void setInboundMessageIssuer(String issuer) {
        this.inboundMessageIssuer = issuer;
    }

    public void setInboundMessageTransport(InTransport transport) {
        this.inboundTransport = transport;
    }

    public void setOutboundMessage(XMLObject message) {
        this.outboundMessage = message;
    }

    public void setOutboundMessageIssuer(String issuer) {
        this.outboundMessageIssuer = issuer;
    }

    public void setOutboundMessageTransport(OutTransport transport) {
        this.outboundTransport = transport;
    }

    public void setSecurityPolicyResolver(SecurityPolicyResolver resolver) {
        this.securityPolicyResolver = resolver;
    }

    public boolean isIssuerAuthenticated() {
        return this.getInboundMessageTransport().isAuthenticated();
    }

    public HandlerChainResolver getPreSecurityInboundHandlerChainResolver() {
        return this.preSecurityInboundHandlerChainResolver;
    }

    public HandlerChainResolver getPostSecurityInboundHandlerChainResolver() {
        return this.postSecurityInboundHandlerChainResolver;
    }

    public HandlerChainResolver getOutboundHandlerChainResolver() {
        return this.outboundHandlerChainResolver;
    }

    public void setPreSecurityInboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.preSecurityInboundHandlerChainResolver = newHandlerChainResolver;
    }

    public void setPostSecurityInboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.postSecurityInboundHandlerChainResolver = newHandlerChainResolver;
    }

    public void setOutboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.outboundHandlerChainResolver = newHandlerChainResolver;
    }
}

