/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import org.apache.axiom.om.OMNode;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class SourceXPathSupport {
    public static final String DEFAULT_XPATH = "s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";
    private SynapseXPath xpath;
    private String xpathString;

    public SynapseXPath getXPath() {
        return this.xpath;
    }

    public void setXPath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public void setXPathString(String xpathString) {
        this.xpathString = xpathString;
    }

    public OMNode selectOMNode(MessageContext synCtx, SynapseLog synLog) {
        Object result;
        if (this.xpath == null) {
            return synCtx.getEnvelope().getBody().getFirstElement();
        }
        try {
            result = this.xpath.selectSingleNode(synCtx);
        }
        catch (JaxenException e) {
            throw new SynapseException("Error evaluating XPath expression : " + (Object)((Object)this.xpath), e, synLog);
        }
        if (result instanceof OMNode) {
            return (OMNode)result;
        }
        if (result instanceof String) {
            return SynapseConfigUtils.stringToOM((String)result);
        }
        throw new SynapseException("The evaluation of the XPath expression " + (Object)((Object)this.xpath) + " did not result in an OMNode : " + result, synLog);
    }

    public String toString() {
        if (this.xpathString != null) {
            return this.xpathString;
        }
        if (this.xpath == null) {
            return DEFAULT_XPATH;
        }
        return this.xpath.toString();
    }
}

