/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Target {
    private SynapseXPath xpath = null;
    private String property = null;
    private int targetType = 0;
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_ADD_CHILD = "child";
    public static final String ACTION_ADD_SIBLING = "sibling";
    private String action = "replace";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(MessageContext synContext, ArrayList<OMNode> sourceNodeList, SynapseLog synLog) throws JaxenException {
        if (this.targetType == 0) {
            assert (this.xpath != null) : "Xpath cannot be null for CUSTOM";
            if (sourceNodeList.isEmpty()) {
                synLog.error("Cannot Enrich message from an empty source.");
                return;
            }
            Object targetObj = this.xpath.selectSingleNode(synContext);
            if (targetObj instanceof OMElement) {
                OMElement targetElem = (OMElement)targetObj;
                this.insertElement(sourceNodeList, targetElem, synLog);
                return;
            }
            if (targetObj instanceof OMText) {
                OMText targetText = (OMText)targetObj;
                if (sourceNodeList.get(0) instanceof OMText) {
                    OMContainer parent;
                    if (targetText.getParent() == null || !((parent = targetText.getParent()) instanceof OMElement)) return;
                    ((OMElement)parent).setText(((OMText)sourceNodeList.get(0)).getText());
                    return;
                } else {
                    OMContainer targetParent;
                    if (!(sourceNodeList.get(0) instanceof OMElement) || !((targetParent = targetText.getParent()) instanceof OMElement)) return;
                    targetText.detach();
                    ((OMElement)targetParent).addChild(sourceNodeList.get(0));
                }
                return;
            }
            if (targetObj instanceof OMAttribute) {
                OMAttribute attribute = (OMAttribute)targetObj;
                if (!(sourceNodeList.get(0) instanceof OMText)) return;
                attribute.setAttributeValue(((OMText)sourceNodeList.get(0)).getText());
                return;
            }
            synLog.error("Invalid Target object to enrich.");
            throw new SynapseException("Invalid Target object to enrich.");
        }
        if (this.targetType == 2) {
            SOAPEnvelope env = synContext.getEnvelope();
            SOAPBody body = env.getBody();
            OMElement e = body.getFirstElement();
            if (e != null) {
                this.insertElement(sourceNodeList, e, synLog);
                return;
            } else {
                for (OMNode elem : sourceNodeList) {
                    if (elem instanceof OMElement) {
                        body.addChild(elem);
                        continue;
                    }
                    synLog.error("Invalid Object type to be inserted into message body");
                }
            }
            return;
        }
        if (this.targetType == 1) {
            OMNode node = sourceNodeList.get(0);
            if (node instanceof SOAPEnvelope) {
                try {
                    synContext.setEnvelope((SOAPEnvelope)node);
                    return;
                }
                catch (AxisFault axisFault) {
                    synLog.error("Failed to set the SOAP Envelope");
                    throw new SynapseException("Failed to set the SOAP Envelope");
                }
            }
            synLog.error("SOAPEnvelope is expected");
            throw new SynapseException("A SOAPEnvelope is expected");
        }
        if (this.targetType != 3) return;
        assert (this.property != null) : "Property cannot be null for PROPERTY type";
        Object propertyObj = synContext.getProperty(this.property);
        if (propertyObj != null && ACTION_ADD_CHILD.equals(this.action)) {
            OMElement documentElement;
            if (propertyObj instanceof OMElement) {
                documentElement = (OMElement)propertyObj;
            } else {
                try {
                    documentElement = AXIOMUtil.stringToOM((String)propertyObj.toString());
                }
                catch (XMLStreamException e) {
                    throw new SynapseException("Error while converting property value into an OMElement");
                }
            }
            this.insertElement(sourceNodeList, documentElement, synLog);
            synContext.setProperty(this.property, documentElement);
            return;
        }
        synContext.setProperty(this.property, sourceNodeList);
    }

    private void insertElement(ArrayList<OMNode> sourceNodeList, OMElement e, SynapseLog synLog) {
        block9: {
            block8: {
                if (!this.action.equals(ACTION_REPLACE)) break block8;
                boolean isInserted = false;
                for (OMNode elem : sourceNodeList) {
                    if (elem instanceof OMElement) {
                        e.insertSiblingAfter(elem);
                        isInserted = true;
                        continue;
                    }
                    if (elem instanceof OMText) {
                        e.setText(((OMText)elem).getText());
                        continue;
                    }
                    synLog.error("Invalid Source object to be inserted.");
                }
                if (!isInserted) break block9;
                e.detach();
                break block9;
            }
            if (this.action.equals(ACTION_ADD_CHILD)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    e.addChild(elem);
                }
            } else if (this.action.equals(ACTION_ADD_SIBLING)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    e.insertSiblingAfter(elem);
                }
            }
        }
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public String getProperty() {
        return this.property;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

