/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.relay;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class ServiceRequestEarlyBuilder
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        OperationContext operationContext = messageContext.getOperationContext();
        if (operationContext == null) {
            AxisService service = messageContext.getAxisService();
            if (service != null) {
                if ("__ADDR_ONLY__".equals(service.getName())) {
                    return this.buildMessage(messageContext);
                }
                AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
                SynapseConfiguration synapseConfig = (SynapseConfiguration)axisConfiguration.getParameterValue("synapse.config");
                ProxyService proxy = synapseConfig.getProxyService(service.getName());
                if (proxy == null) return Handler.InvocationResponse.CONTINUE;
                AxisOperation operation = messageContext.getAxisOperation();
                if (proxy.isModuleEngaged() || operation == null && proxy.isWsdlPublished()) {
                    return this.buildMessage(messageContext);
                }
                if (operation == null && !proxy.isWsdlPublished()) {
                    operation = service.getOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
                }
                if (operation == null) return Handler.InvocationResponse.CONTINUE;
                return this.invokeMessageReceiver(messageContext, operation);
            }
            service = messageContext.getConfigurationContext().getAxisConfiguration().getService("__SynapseService");
            messageContext.setAxisService(service);
            AxisOperation operation = service.getOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
            messageContext.setAxisOperation(operation);
            return this.invokeMessageReceiver(messageContext, operation);
        }
        MessageContext outMessage = operationContext.getMessageContext("Out");
        if (outMessage == null || !Boolean.TRUE.equals(outMessage.getProperty("FORCE_RESPONSE_EARLY_BUILD"))) return Handler.InvocationResponse.CONTINUE;
        return this.buildMessage(messageContext);
    }

    private Handler.InvocationResponse invokeMessageReceiver(MessageContext messageContext, AxisOperation operation) throws AxisFault {
        messageContext.getConfigurationContext().fillServiceContextAndServiceGroupContext(messageContext);
        OperationContext opContext = operation.findOperationContext(messageContext, messageContext.getServiceContext());
        messageContext.setOperationContext(opContext);
        operation.getMessageReceiver().receive(messageContext);
        return Handler.InvocationResponse.ABORT;
    }

    private Handler.InvocationResponse buildMessage(MessageContext messageContext) throws AxisFault {
        try {
            RelayUtils.buildMessage((MessageContext)messageContext, (boolean)true);
        }
        catch (IOException e) {
            throw new AxisFault("I/O error while reading from the input stream");
        }
        catch (XMLStreamException e) {
            throw new AxisFault("Unexpected error while parsing the XML content");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

