/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import org.apache.tools.ant.Task;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CopyAction
extends Action {
    protected final String buffer;
    protected final boolean append;
    protected final boolean attrValue;
    protected final Task task;
    protected final boolean isProperty;

    public CopyAction(String buffer, boolean append, boolean attrValue, Task task, boolean isProperty) {
        this.buffer = buffer;
        this.append = append;
        this.attrValue = attrValue;
        this.task = task;
        this.isProperty = isProperty;
    }

    protected void record(Node node) throws Exception {
        if (node instanceof Attr && this.attrValue) {
            node = node.getOwnerDocument().createTextNode(((Attr)node).getValue());
        }
        if (!this.isProperty) {
            BufferStore.set(this.buffer, node, this.append, this.task);
        } else {
            if (node instanceof Text || node instanceof Comment) {
                this.task.getProject().setNewProperty(this.buffer, node.getNodeValue());
            } else {
                this.task.log("Can only copy/cut text() nodes and attribute values to properties", 1);
            }
            if (this.append) {
                this.task.log("Cannot append values to properties", 1);
            }
        }
    }

    public boolean apply(Node node) throws Exception {
        this.record(node);
        return true;
    }

    public String toString() {
        return "CopyAction(" + this.buffer + ")";
    }
}

