/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.fix.FIXIncomingMessageHandler;
import org.apache.synapse.transport.fix.FIXSessionFactory;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;

public class FIXOutgoingMessageHandler {
    private static final Log log = LogFactory.getLog(FIXOutgoingMessageHandler.class);
    private Map<String, Integer> countersMap = new ConcurrentHashMap<String, Integer>();
    private Map<String, Map<Integer, Object[]>> messagesMap = new ConcurrentHashMap<String, Map<Integer, Object[]>>();
    private FIXSessionFactory sessionFactory;

    public void setSessionFactory(FIXSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public synchronized void sendMessage(Message message, SessionID targetSession, String sourceSession, int counter, MessageContext msgCtx, String targetEPR) throws SessionNotFound {
        boolean ignoreOrder = "true".equals(msgCtx.getProperty("transport.fix.IgnoreOrder"));
        if (sourceSession != null && counter != -1 && !ignoreOrder) {
            int expectedValue;
            if (this.countersMap.containsKey(sourceSession)) {
                expectedValue = this.countersMap.get(sourceSession);
            } else {
                this.countersMap.put(sourceSession, 1);
                this.messagesMap.put(sourceSession, new ConcurrentHashMap());
                expectedValue = 1;
            }
            if (expectedValue == counter) {
                this.sendToTarget(msgCtx, targetEPR, message, targetSession);
                if (1000000000 == expectedValue) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Outgoing request counter rolled over for the session: " + sourceSession + " (from " + expectedValue + ")"));
                    }
                    expectedValue = 1;
                }
                this.countersMap.put(sourceSession, ++expectedValue);
                this.sendQueuedMessages(expectedValue, sourceSession);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Source session: " + sourceSession + " - Expected sequence number (" + expectedValue + ") does not match with the actual sequence number (" + counter + "). Holding the message back for later delivery."));
                }
                Map<Integer, Object[]> messages = this.messagesMap.get(sourceSession);
                Object[] obj = new Object[]{message, targetSession, msgCtx, targetEPR};
                messages.put(counter, obj);
            }
        } else {
            this.sendToTarget(msgCtx, targetEPR, message, targetSession);
        }
    }

    private void sendToTarget(MessageContext msgCtx, String targetEPR, Message message, SessionID sessionID) throws SessionNotFound {
        FIXIncomingMessageHandler messageHandler;
        if (msgCtx != null && targetEPR != null && (messageHandler = (FIXIncomingMessageHandler)this.sessionFactory.getApplication(targetEPR)) != null) {
            messageHandler.setOutgoingMessageContext(msgCtx);
        }
        Session.sendToTarget((Message)message, (SessionID)sessionID);
    }

    private void sendQueuedMessages(int expectedValue, String session) throws SessionNotFound {
        Map<Integer, Object[]> messages = this.messagesMap.get(session);
        Object[] obj = messages.get(expectedValue);
        while (obj != null) {
            Message message = (Message)obj[0];
            SessionID sessionID = (SessionID)obj[1];
            MessageContext msgCtx = null;
            String targetEPR = null;
            if (obj[2] != null) {
                msgCtx = (MessageContext)obj[2];
                targetEPR = (String)obj[3];
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source session: " + session + " - Sending the previously queued message with the sequence number: " + expectedValue));
            }
            this.sendToTarget(msgCtx, targetEPR, message, sessionID);
            messages.remove(expectedValue);
            if (1000000000 == expectedValue) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Outgoing request counter rolled over for the session: " + session + " (from " + expectedValue + ")"));
                }
                expectedValue = 1;
            }
            obj = messages.get(++expectedValue);
        }
        this.messagesMap.put(session, messages);
        this.countersMap.put(session, expectedValue);
    }

    public void cleanUpMessages(String session) {
        if (this.countersMap.containsKey(session)) {
            int expectedValue = this.countersMap.get(session);
            Map<Integer, Object[]> messages = this.messagesMap.get(session);
            while (!messages.isEmpty()) {
                Object[] obj = messages.get(expectedValue);
                if (obj != null) {
                    Message message = (Message)obj[0];
                    SessionID sessionID = (SessionID)obj[1];
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Source session: " + session + " - Flushing the previously queued message with the sequence number: " + expectedValue));
                    }
                    try {
                        Session.sendToTarget((Message)message, (SessionID)sessionID);
                    }
                    catch (SessionNotFound sessionNotFound) {
                        // empty catch block
                    }
                    messages.remove(expectedValue);
                }
                ++expectedValue;
            }
            this.messagesMap.remove(session);
            this.countersMap.remove(session);
        }
    }
}

