/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ConversationException
extends Exception {
    private static final long serialVersionUID = 970894530660804319L;
    public static final String BAD_CONTEXT_TOKEN = "BadContextToken";
    public static final String UNSUPPORTED_CONTEXT_TOKEN = "UnsupportedContextToken";
    public static final String UNKNOWN_DERIVATION_SOURCE = "UnknownDerivationSource";
    public static final String RENEW_NEEDED = "RenewNeeded";
    public static final String UNABLE_TO_REVIEW = "UnableToRenew";
    private static final ResourceBundle resources;
    private String faultCode;
    private String faultString;

    public ConversationException(String faultCode, Object[] args) {
        super(ConversationException.getMessage(faultCode, args));
        this.faultCode = this.getFaultCode(faultCode);
        this.faultString = ConversationException.getMessage(faultCode, args);
    }

    private String getFaultCode(String code) {
        if (BAD_CONTEXT_TOKEN.equals(code) || UNABLE_TO_REVIEW.equals(code) || UNKNOWN_DERIVATION_SOURCE.equals(code) || UNSUPPORTED_CONTEXT_TOKEN.equals(code) || RENEW_NEEDED.equals(code)) {
            return "wsc:" + code;
        }
        return code;
    }

    public ConversationException(String faultCode) {
        this(faultCode, (Object[])null);
    }

    public ConversationException(String faultCode, Object[] args, Throwable e) {
        super(ConversationException.getMessage(faultCode, args), e);
        this.faultCode = faultCode;
        this.faultString = ConversationException.getMessage(faultCode, args);
    }

    public ConversationException(String faultCode, Throwable e) {
        this(faultCode, null, e);
    }

    protected static String getMessage(String faultCode, Object[] args) {
        String msg = null;
        try {
            msg = MessageFormat.format(resources.getString(faultCode), args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + faultCode + "' resource property", e);
        }
        if (msg != null) {
            return msg;
        }
        return faultCode;
    }

    protected String getFaultCode() {
        return this.faultCode;
    }

    protected String getFaultString() {
        return this.faultString;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.apache.ws.security.conversation.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

