/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;

public class SortNode
extends AbstractSingleNode<Sort> {
    public SortNode(Interpreter interpreter, Sort rel) {
        super(interpreter, rel);
    }

    @Override
    public void run() throws InterruptedException {
        block10: {
            int fetch;
            int offset = ((Sort)this.rel).offset == null ? 0 : ((BigDecimal)((RexLiteral)((Sort)this.rel).offset).getValue()).intValue();
            int n = fetch = ((Sort)this.rel).fetch == null ? -1 : ((BigDecimal)((RexLiteral)((Sort)this.rel).fetch).getValue()).intValue();
            if (((Sort)this.rel).getCollation().getFieldCollations().isEmpty()) {
                Row row;
                int i;
                for (i = 0; i < offset; ++i) {
                    row = this.source.receive();
                    if (row != null) {
                        continue;
                    }
                    break block10;
                }
                if (fetch >= 0) {
                    for (i = 0; i < fetch && (row = this.source.receive()) != null; ++i) {
                        this.sink.send(row);
                    }
                } else {
                    while ((row = this.source.receive()) != null) {
                        this.sink.send(row);
                    }
                }
            } else {
                Row row;
                ArrayList list = Lists.newArrayList();
                while ((row = this.source.receive()) != null) {
                    list.add(row);
                }
                Collections.sort(list, this.comparator());
                int end = fetch < 0 || offset + fetch > list.size() ? list.size() : offset + fetch;
                for (int i = offset; i < end; ++i) {
                    this.sink.send((Row)list.get(i));
                }
            }
        }
        this.sink.end();
    }

    private Comparator<Row> comparator() {
        if (((Sort)this.rel).getCollation().getFieldCollations().size() == 1) {
            return this.comparator(((Sort)this.rel).getCollation().getFieldCollations().get(0));
        }
        return Ordering.compound((Iterable)Iterables.transform(((Sort)this.rel).getCollation().getFieldCollations(), (Function)new Function<RelFieldCollation, Comparator<? super Row>>(){

            public Comparator<? super Row> apply(RelFieldCollation input) {
                return SortNode.this.comparator(input);
            }
        }));
    }

    private Comparator<Row> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        Comparable c1 = (Comparable)o1.getValues()[x];
                        Comparable c2 = (Comparable)o2.getValues()[x];
                        return RelFieldCollation.compare(c1, c2, nullComparison);
                    }
                };
            }
        }
        return new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                Comparable c1 = (Comparable)o1.getValues()[x];
                Comparable c2 = (Comparable)o2.getValues()[x];
                return RelFieldCollation.compare(c2, c1, -nullComparison);
            }
        };
    }
}

