/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.mongodb;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.mongodb.common.mapper.MongoMapper;
import org.apache.storm.mongodb.trident.state.MongoState;
import org.apache.storm.mongodb.trident.state.MongoStateFactory;
import org.apache.storm.mongodb.trident.state.MongoStateUpdater;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.sql.runtime.SimpleSqlTridentConsumer;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.trident.spout.ITridentDataSource;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.tuple.ITuple;
import org.bson.Document;

public class MongoDataSourcesProvider
implements DataSourcesProvider {
    public String scheme() {
        return "mongodb";
    }

    public DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        throw new UnsupportedOperationException();
    }

    public ISqlTridentDataSource constructTrident(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        List fieldNames = FieldInfoUtils.getFieldNames(fields);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)properties, (List)fieldNames);
        return new MongoTridentDataSource(uri.toString(), properties, serializer);
    }

    private static class TridentMongoMapper
    implements MongoMapper {
        private final String serField;
        private final IOutputSerializer serializer;

        private TridentMongoMapper(String serField, IOutputSerializer serializer) {
            this.serField = serField;
            this.serializer = serializer;
        }

        public Document toDocument(ITuple tuple) {
            Document document = new Document();
            byte[] array = this.serializer.write(tuple.getValues(), null).array();
            document.append(this.serField, (Object)array);
            return document;
        }
    }

    private static class MongoTridentDataSource
    implements ISqlTridentDataSource {
        private final String url;
        private final Properties props;
        private final IOutputSerializer serializer;

        private MongoTridentDataSource(String url, Properties props, IOutputSerializer serializer) {
            this.url = url;
            this.props = props;
            this.serializer = serializer;
        }

        public ITridentDataSource getProducer() {
            throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide Producer");
        }

        public ISqlTridentDataSource.SqlTridentConsumer getConsumer() {
            Preconditions.checkArgument((!this.props.isEmpty() ? 1 : 0) != 0, (Object)"Writable MongoDB must contain collection config");
            String serField = this.props.getProperty("trident.ser.field", "tridentSerField");
            TridentMongoMapper mapper = new TridentMongoMapper(serField, this.serializer);
            MongoState.Options options = new MongoState.Options().withUrl(this.url).withCollectionName(this.props.getProperty("collection.name")).withMapper((MongoMapper)mapper);
            MongoStateFactory stateFactory = new MongoStateFactory(options);
            MongoStateUpdater stateUpdater = new MongoStateUpdater();
            return new SimpleSqlTridentConsumer((StateFactory)stateFactory, (StateUpdater)stateUpdater);
        }
    }
}

