/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.launch.BundleScanner;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SisuExtender
implements BundleActivator {
    private static final Map<Long, MutableBeanLocator> locators = Collections.synchronizedMap(Weak.values());
    private BundleScanner scanner;

    public void start(BundleContext context) {
        this.scanner = this.createScanner(context);
        this.scanner.open();
    }

    public void stop(BundleContext context) {
        this.scanner.close();
        this.scanner = null;
    }

    public final MutableBeanLocator findLocator(BundleContext context) {
        Long extenderId = context.getBundle().getBundleId();
        MutableBeanLocator locator = locators.get(extenderId);
        if (locator == null) {
            locator = this.createLocator(context);
            locators.put(extenderId, locator);
        }
        return locator;
    }

    protected int bundleStateMask() {
        return 40;
    }

    protected BundleScanner createScanner(BundleContext context) {
        return new BundleScanner(context, this.bundleStateMask(), this.findLocator(context));
    }

    protected MutableBeanLocator createLocator(BundleContext context) {
        return new DefaultBeanLocator();
    }
}

