/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.serversetup.instance;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.osgi.BundlesInstaller;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.util.TimeoutsProvider;
import org.apache.sling.testing.serversetup.instance.SlingInstance;
import org.apache.sling.testing.serversetup.instance.SlingInstanceState;
import org.apache.sling.testing.serversetup.jarexec.JarExecutor;
import org.junit.After;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingTestBase
implements SlingInstance {
    public static final String TEST_SERVER_URL_PROP = "test.server.url";
    public static final String TEST_SERVER_USERNAME = "test.server.username";
    public static final String TEST_SERVER_PASSWORD = "test.server.password";
    public static final String SERVER_READY_TIMEOUT_PROP = "server.ready.timeout.seconds";
    public static final String SERVER_READY_TIMEOUT_INITIAL_DELAY_PROP = "server.ready.timeout.initial.delay.seconds";
    public static final String SERVER_READY_TIMEOUT_DELAY_PROP = "server.ready.timeout.delay.seconds";
    public static final String SERVER_READY_QUIET_PERIOD_PROP = "server.ready.quiet.period.seconds";
    public static final String SERVER_READY_PROP_PREFIX = "server.ready.path";
    public static final String KEEP_JAR_RUNNING_PROP = "keepJarRunning";
    public static final String SERVER_HOSTNAME_PROP = "test.server.hostname";
    public static final String ADDITONAL_BUNDLES_PATH = "additional.bundles.path";
    public static final String ADDITONAL_BUNDLES_UNINSTALL = "additional.bundles.uninstall";
    public static final String BUNDLE_TO_INSTALL_PREFIX = "sling.additional.bundle";
    public static final String START_BUNDLES_TIMEOUT_SECONDS = "start.bundles.timeout.seconds";
    public static final String BUNDLE_INSTALL_TIMEOUT_SECONDS = "bundle.install.timeout.seconds";
    public static final String ADMIN = "admin";
    private final boolean keepJarRunning;
    private final boolean uninstallAdditionalBundles;
    private final String serverUsername;
    private final String serverPassword;
    private final SlingInstanceState slingTestState;
    private final Properties systemProperties;
    private OsgiConsoleClient osgiConsoleClient;
    private BundlesInstaller bundlesInstaller;
    private boolean serverStartedByThisClass;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SlingTestBase() {
        this(SlingInstanceState.getInstance("default"), System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingTestBase(SlingInstanceState slingTestState, Properties systemProperties) {
        this.slingTestState = slingTestState;
        this.systemProperties = systemProperties;
        this.keepJarRunning = "true".equals(systemProperties.getProperty(KEEP_JAR_RUNNING_PROP));
        String configuredUrl = systemProperties.getProperty(TEST_SERVER_URL_PROP, systemProperties.getProperty("launchpad.http.server.url"));
        if (configuredUrl != null && configuredUrl.trim().length() > 0) {
            slingTestState.setServerBaseUrl(configuredUrl);
            slingTestState.setServerStarted(true);
            this.uninstallAdditionalBundles = "true".equals(systemProperties.getProperty(ADDITONAL_BUNDLES_UNINSTALL));
        } else {
            SlingInstanceState slingInstanceState = this.slingTestState;
            synchronized (slingInstanceState) {
                try {
                    if (slingTestState.getJarExecutor() == null) {
                        slingTestState.setJarExecutor(new JarExecutor(systemProperties));
                    }
                }
                catch (Exception e) {
                    this.log.error("JarExecutor setup failed", (Throwable)e);
                    Assert.fail((String)("JarExecutor setup failed: " + e));
                }
            }
            String serverHost = systemProperties.getProperty(SERVER_HOSTNAME_PROP);
            if (serverHost == null || serverHost.trim().length() == 0) {
                serverHost = "localhost";
            }
            slingTestState.setServerBaseUrl("http://" + serverHost + ":" + slingTestState.getJarExecutor().getServerPort());
            this.uninstallAdditionalBundles = false;
        }
        String configuredUsername = systemProperties.getProperty(TEST_SERVER_USERNAME);
        this.serverUsername = configuredUsername != null && configuredUsername.trim().length() > 0 ? configuredUsername : ADMIN;
        String configuredPassword = systemProperties.getProperty(TEST_SERVER_PASSWORD);
        this.serverPassword = configuredPassword != null && configuredPassword.trim().length() > 0 ? configuredPassword : ADMIN;
        try {
            this.osgiConsoleClient = new OsgiConsoleClient(URI.create(slingTestState.getServerBaseUrl()), this.serverUsername, this.serverPassword);
        }
        catch (ClientException e) {
            throw new RuntimeException("Cannot instantiate client", e);
        }
        this.bundlesInstaller = new BundlesInstaller(this.osgiConsoleClient);
        if (!slingTestState.isServerInfoLogged()) {
            this.log.info("Server base URL={}", (Object)slingTestState.getServerBaseUrl());
            slingTestState.setServerInfoLogged(true);
        }
    }

    @After
    public void uninstallAdditionalBundlesIfNecessary() {
        if (this.uninstallAdditionalBundles) {
            this.log.info("Uninstalling additional bundles...");
            this.uninstallAdditionalBundles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerIfNeeded() {
        try {
            if (this.slingTestState.isServerStarted() && !this.serverStartedByThisClass && !this.slingTestState.isStartupInfoProvided()) {
                this.log.info("test.server.url was set: not starting server jar (" + this.slingTestState.getServerBaseUrl() + ")");
            }
            if (!this.slingTestState.isServerStarted()) {
                SlingInstanceState slingInstanceState = this.slingTestState;
                synchronized (slingInstanceState) {
                    if (!this.slingTestState.isServerStarted()) {
                        this.slingTestState.getJarExecutor().start();
                        this.serverStartedByThisClass = true;
                        if (!this.slingTestState.setServerStarted(true)) {
                            Assert.fail((String)("A server is already started at " + this.slingTestState.getServerBaseUrl()));
                        }
                    }
                }
            }
            this.slingTestState.setStartupInfoProvided(true);
            this.waitForServerReady();
            this.installAdditionalBundles();
            this.waitForQuietPeriod();
            this.blockIfRequested();
        }
        catch (Exception e) {
            this.log.error("Exception in maybeStartServer()", (Throwable)e);
            Assert.fail((String)("maybeStartServer() failed: " + e));
        }
    }

    protected void waitForQuietPeriod() throws InterruptedException {
        String quietPeriodSecProp = this.systemProperties.getProperty(SERVER_READY_QUIET_PERIOD_PROP, "0");
        int quietPeriodSec = TimeoutsProvider.getInstance().getTimeout(Integer.valueOf(quietPeriodSecProp).intValue());
        int quietPeriodMs = quietPeriodSec * 1000;
        if (quietPeriodMs > 0) {
            this.log.info("Waiting {} seconds as a quiet period", (Object)quietPeriodSec);
            Thread.sleep(quietPeriodMs);
        }
    }

    protected void installAdditionalBundles() {
        if (this.slingTestState.isInstallBundlesFailed()) {
            Assert.fail((String)"Bundles could not be installed, cannot run tests");
        } else if (!this.slingTestState.isExtraBundlesInstalled()) {
            List<File> toInstall = this.getBundlesToInstall();
            if (!toInstall.isEmpty()) {
                try {
                    this.bundlesInstaller.installBundles(toInstall, false);
                    LinkedList<String> symbolicNames = new LinkedList<String>();
                    for (File f : toInstall) {
                        symbolicNames.add(OsgiConsoleClient.getBundleSymbolicName((File)f));
                    }
                    this.bundlesInstaller.waitForBundlesInstalled(symbolicNames, TimeoutsProvider.getInstance().getTimeout(BUNDLE_INSTALL_TIMEOUT_SECONDS, 10) * 1000);
                    this.bundlesInstaller.startAllBundles(symbolicNames, TimeoutsProvider.getInstance().getTimeout(START_BUNDLES_TIMEOUT_SECONDS, 30) * 1000);
                }
                catch (AssertionError ae) {
                    this.log.info("Exception while installing additional bundles", (Throwable)((Object)ae));
                    this.slingTestState.setInstallBundlesFailed(true);
                }
                catch (Exception e) {
                    this.log.info("Exception while installing additional bundles", (Throwable)e);
                    this.slingTestState.setInstallBundlesFailed(true);
                }
                if (this.slingTestState.isInstallBundlesFailed()) {
                    Assert.fail((String)("Could not start all installed bundles:" + toInstall));
                }
            } else {
                this.log.info("Not installing additional bundles, probably System property {} not set", (Object)ADDITONAL_BUNDLES_PATH);
            }
        }
        this.slingTestState.setExtraBundlesInstalled(!this.slingTestState.isInstallBundlesFailed());
    }

    protected void uninstallAdditionalBundles() {
        try {
            this.bundlesInstaller.uninstallBundles(this.getBundlesToInstall());
        }
        catch (Exception e) {
            this.log.info("Exception while uninstalling additional bundles", (Throwable)e);
        }
    }

    @Override
    public String getServerBaseUrl() {
        this.startServerIfNeeded();
        return this.slingTestState.getServerBaseUrl();
    }

    @Override
    public String getServerUsername() {
        return this.serverUsername;
    }

    @Override
    public String getServerPassword() {
        return this.serverPassword;
    }

    @Override
    public SlingClient getSlingClient() {
        return this.osgiConsoleClient;
    }

    public OsgiConsoleClient getOsgiConsoleClient() {
        this.startServerIfNeeded();
        return this.osgiConsoleClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockIfRequested() {
        if (this.keepJarRunning) {
            this.log.info("keepJarRunning set to true - entering infinite loop so that runnable jar stays up. Kill this process to exit.");
            SlingInstanceState slingInstanceState = this.slingTestState;
            synchronized (slingInstanceState) {
                try {
                    this.slingTestState.wait();
                }
                catch (InterruptedException iex) {
                    this.log.info("InterruptedException in blockIfRequested");
                }
            }
        }
    }

    protected void waitForServerReady() throws Exception {
        if (this.slingTestState.isServerReady()) {
            return;
        }
        if (this.slingTestState.isServerReadyTestFailed()) {
            Assert.fail((String)"Server is not ready according to previous tests");
        }
        TimeoutsProvider tp = TimeoutsProvider.getInstance();
        String sec = this.systemProperties.getProperty(SERVER_READY_TIMEOUT_PROP, "60");
        int timeoutSec = tp.getTimeout(Integer.valueOf(sec).intValue());
        String initialDelaySec = this.systemProperties.getProperty(SERVER_READY_TIMEOUT_INITIAL_DELAY_PROP, "0");
        int timeoutInitialDelaySec = tp.getTimeout(Integer.valueOf(initialDelaySec).intValue());
        int timeoutInitialDelayMs = timeoutInitialDelaySec * 1000;
        String delaySec = this.systemProperties.getProperty(SERVER_READY_TIMEOUT_DELAY_PROP, "1");
        int timeoutDelaySec = tp.getTimeout(Integer.valueOf(delaySec).intValue());
        int timeoutDelayMs = timeoutDelaySec * 1000;
        this.log.info("Will wait up to {} seconds for server to become ready with a {} second initial delay and {} seconds between each check", new Object[]{timeoutSec, timeoutInitialDelaySec, timeoutDelaySec});
        long endTime = System.currentTimeMillis() + (long)timeoutSec * 1000L;
        ArrayList<String> testPaths = new ArrayList<String>();
        TreeSet<Object> propertyNames = new TreeSet<Object>();
        propertyNames.addAll(this.systemProperties.keySet());
        for (Object e : propertyNames) {
            String key = (String)e;
            if (!key.startsWith(SERVER_READY_PROP_PREFIX)) continue;
            testPaths.add(this.systemProperties.getProperty(key));
        }
        if (timeoutInitialDelayMs > 0) {
            Thread.sleep(timeoutInitialDelayMs);
        }
        this.log.info("Checking that GET requests return expected content (timeout={} seconds): {}", (Object)timeoutSec, testPaths);
        while (System.currentTimeMillis() < endTime) {
            boolean errors = false;
            for (String p : testPaths) {
                String[] s = p.split(":");
                String path = s[0];
                String pattern = s.length > 0 ? s[1] : "";
                boolean isRegex = s.length > 1 ? "regexp".equals(s[2]) : false;
                try {
                    URI uri = new URI(path);
                    List<NameValuePair> reqParams = this.extractParams(uri);
                    SlingHttpResponse get = this.osgiConsoleClient.doGet(uri.getPath(), reqParams, new int[]{200});
                    if (isRegex) {
                        get.checkContentRegexp(new String[]{pattern});
                        continue;
                    }
                    get.checkContentContains(new String[]{pattern});
                }
                catch (ClientException e) {
                    errors = true;
                    this.log.debug("Request to {}@{} failed, will retry ({})", new Object[]{this.serverUsername, this.osgiConsoleClient.getUrl(path), e});
                }
                catch (Exception e) {
                    errors = true;
                    this.log.debug("Request to {}@{} failed, will retry ({})", new Object[]{this.serverUsername, this.osgiConsoleClient.getUrl(path), pattern, e});
                }
            }
            if (!errors) {
                this.slingTestState.setServerReady(true);
                this.log.info("All {} paths return expected content, server ready", (Object)testPaths.size());
                break;
            }
            Thread.sleep(timeoutDelayMs);
        }
        if (!this.slingTestState.isServerReady()) {
            this.slingTestState.setServerReadyTestFailed(true);
            String msg = "Server not ready after " + timeoutSec + " seconds, giving up";
            this.log.info(msg);
            Assert.fail((String)msg);
        }
    }

    protected List<NameValuePair> extractParams(URI url) throws UnsupportedEncodingException {
        String[] pairs;
        ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
        String query = url.getQuery();
        if (query == null || query.isEmpty()) {
            return null;
        }
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            paramsList.add((NameValuePair)new BasicNameValuePair(key, value));
        }
        return paramsList;
    }

    protected List<File> getBundlesToInstall() {
        String[] allPaths;
        String paths = this.systemProperties.getProperty(ADDITONAL_BUNDLES_PATH);
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<File> toInstall = new ArrayList<File>();
        for (String path : allPaths = paths.split(",")) {
            toInstall.addAll(this.getBundlesToInstall(path.trim()));
        }
        return toInstall;
    }

    protected List<File> getBundlesToInstall(String additionalBundlesPath) {
        LinkedList<File> result = new LinkedList<File>();
        if (additionalBundlesPath == null) {
            return result;
        }
        File dir = new File(additionalBundlesPath);
        if (!dir.isDirectory() || !dir.canRead()) {
            this.log.info("Cannot read additional bundles directory {}, ignored", (Object)dir.getAbsolutePath());
            return result;
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        String[] files = dir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.endsWith(".jar")) continue;
                bundleNames.add(file);
            }
        }
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        for (Object key : this.systemProperties.keySet()) {
            String str = key.toString();
            if (!str.startsWith(BUNDLE_TO_INSTALL_PREFIX)) continue;
            sortedPropertyKeys.add(str);
        }
        Collections.sort(sortedPropertyKeys);
        for (String key : sortedPropertyKeys) {
            String filenamePrefix = this.systemProperties.getProperty(key);
            for (String bundleFilename : bundleNames) {
                if (!bundleFilename.startsWith(filenamePrefix)) continue;
                result.add(new File(dir, bundleFilename));
            }
        }
        return result;
    }

    public boolean isServerStartedByThisClass() {
        return this.serverStartedByThisClass;
    }
}

