/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class MapMergeUtil {
    static final AtomicLong COMPONENT_ID_COUNTER = new AtomicLong();

    private MapMergeUtil() {
    }

    static Dictionary<String, Object> propertiesMergeWithOsgiMetadata(Class<?> targetClass, ConfigurationAdmin configAdmin, Dictionary<String, Object> properties) {
        return MapUtil.toDictionary(MapMergeUtil.propertiesMergeWithOsgiMetadata(targetClass, configAdmin, MapUtil.toMap(properties)));
    }

    static Map<String, Object> propertiesMergeWithOsgiMetadata(Class<?> targetClass, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        Map<String, Object> metadataProperties;
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata != null && (metadataProperties = metadata.getProperties()) != null) {
            mergedProperties.putAll(metadataProperties);
            if (configAdmin != null) {
                for (String pid : metadata.getConfigurationPID()) {
                    if (pid == null) continue;
                    try {
                        Configuration config = configAdmin.getConfiguration(pid);
                        Dictionary caProperties = config.getProperties();
                        if (caProperties == null) continue;
                        mergedProperties.putAll(MapUtil.toMap(caProperties));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to read config for pid " + pid, ex);
                    }
                }
            }
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        mergedProperties.put("component.name", targetClass.getName());
        mergedProperties.put("component.id", COMPONENT_ID_COUNTER.getAndIncrement());
        return mergedProperties;
    }
}

