/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.exceptions.TestingIOException;
import org.apache.sling.testing.clients.exceptions.TestingValidationException;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class AbstractSlingClient
implements HttpClient,
Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final URI slash = URI.create("/");
    private final String clientId = this.getClass() + "-" + UUID.randomUUID().toString();
    private final CloseableHttpClient http;
    private final SlingClientConfig config;

    AbstractSlingClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        this.http = http;
        this.config = config;
    }

    protected String getClientId() {
        return this.clientId;
    }

    public URI getUrl() {
        return this.config.getUrl();
    }

    public String getUser() {
        return this.config.getUser();
    }

    public String getPassword() {
        return this.config.getPassword();
    }

    public URI getUrl(String path) {
        try {
            URI pathUri = new URI(null, null, path, null);
            URI relative = slash.relativize(pathUri);
            return this.getUrl().resolve(relative);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI getUrl(String path, List<NameValuePair> parameters) {
        URIBuilder uriBuilder = new URIBuilder(this.getUrl(path));
        if (parameters != null) {
            uriBuilder.addParameters(parameters);
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI getPath(URI url) {
        if (url.relativize(this.getUrl()).equals(URI.create(""))) {
            return slash;
        }
        URI contextPath = URI.create(this.getUrl().getPath());
        URI relativeUrl = contextPath.relativize(slash.resolve(url));
        if (relativeUrl.relativize(contextPath).equals(URI.create(""))) {
            return slash;
        }
        return slash.resolve(this.getUrl().relativize(relativeUrl));
    }

    public URI getPath(String url) {
        try {
            return this.getPath(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends AbstractSlingClient> T adaptTo(Class<T> clientClass) throws TestingValidationException {
        AbstractSlingClient client;
        try {
            Constructor<T> cons = clientClass.getConstructor(CloseableHttpClient.class, SlingClientConfig.class);
            client = (AbstractSlingClient)cons.newInstance(this.http, this.config);
        }
        catch (Exception e) {
            throw new TestingValidationException("Could not initialize client: '" + clientClass.getCanonicalName() + "'.", e);
        }
        return (T)client;
    }

    public String getValue(String key) {
        return this.config.getValues().get(key);
    }

    public void addValue(String key, String value) {
        this.config.getValues().put(key, value);
    }

    public boolean hasValue(String key) {
        return this.config.getValues().containsKey(key);
    }

    public Map<String, String> getValues() {
        return this.config.getValues();
    }

    public CookieStore getCookieStore() {
        return this.config.getCookieStore();
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.config.getCredsProvider();
    }

    public SlingHttpResponse doStreamRequest(HttpUriRequest request, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpClientContext context = this.createHttpClientContextFromConfig();
        context.setAttribute("expected_status", (Object)expectedStatus);
        if (headers != null) {
            request.setHeaders(headers.toArray(new Header[headers.size()]));
        }
        SlingHttpResponse response = null;
        try {
            this.log.debug("request {} {}", (Object)request.getMethod(), (Object)request.getURI());
            response = new SlingHttpResponse(this.execute(request, (HttpContext)context));
            this.log.debug("response {}", (Object)HttpUtils.getHttpStatus((HttpResponse)response));
            if (expectedStatus != null && expectedStatus.length > 0) {
                try {
                    HttpUtils.verifyHttpStatus(response, expectedStatus);
                }
                catch (ClientException e) {
                    response.close();
                    e.setRequest(request);
                    e.setResponse(response);
                    throw e;
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new TestingIOException("Could not execute http request", (Throwable)e, request, response);
        }
    }

    public SlingHttpResponse doRawRequest(String method, String uri, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpClientContext context = this.createHttpClientContextFromConfig();
        context.setAttribute("expected_status", (Object)expectedStatus);
        HttpHost host = new HttpHost(this.getUrl().getHost(), this.getUrl().getPort(), this.getUrl().getScheme());
        BasicHttpRequest request = new BasicHttpRequest(method, uri);
        if (headers != null) {
            request.setHeaders(headers.toArray(new Header[headers.size()]));
        }
        try {
            this.log.debug("request {} {}", (Object)method, (Object)uri);
            SlingHttpResponse response = new SlingHttpResponse(this.execute(host, (HttpRequest)request, (HttpContext)context));
            this.log.debug("response {}", (Object)HttpUtils.getHttpStatus((HttpResponse)response));
            if (expectedStatus != null && expectedStatus.length > 0) {
                try {
                    HttpUtils.verifyHttpStatus(response, expectedStatus);
                }
                catch (ClientException e) {
                    response.close();
                    throw e;
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new TestingIOException("Could not execute http request", e);
        }
    }

    private HttpClientContext createHttpClientContextFromConfig() {
        HttpClientContext context = HttpClientContext.create();
        if (this.config.getCookieStore() != null) {
            context.setCookieStore(this.config.getCookieStore());
        }
        if (this.config.getCredsProvider() != null) {
            context.setCredentialsProvider(this.config.getCredsProvider());
        }
        if (this.config.getAuthCache() != null) {
            context.setAuthCache(this.config.getAuthCache());
        }
        return context;
    }

    public SlingHttpResponse doStreamGet(String requestPath, List<NameValuePair> parameters, List<Header> headers, int ... expectedStatus) throws ClientException {
        URI uri = this.getUrl(requestPath, parameters);
        HttpGet request = new HttpGet(uri);
        return this.doStreamRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doStreamPost(String requestPath, HttpEntity entity, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpPost request = new HttpPost(this.getUrl(requestPath));
        if (entity != null) {
            request.setEntity(entity);
        }
        return this.doStreamRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doRequest(HttpUriRequest request, List<Header> headers, int ... expectedStatus) throws ClientException {
        SlingHttpResponse response = this.doStreamRequest(request, headers, expectedStatus);
        response.getContent();
        return response;
    }

    public SlingHttpResponse doGet(String requestPath, List<NameValuePair> parameters, List<Header> headers, int ... expectedStatus) throws ClientException {
        SlingHttpResponse response = this.doStreamGet(requestPath, parameters, headers, expectedStatus);
        response.getContent();
        return response;
    }

    public SlingHttpResponse doGet(String requestPath, List<NameValuePair> parameters, int ... expectedStatus) throws ClientException {
        return this.doGet(requestPath, parameters, null, expectedStatus);
    }

    public SlingHttpResponse doGet(String requestPath, int ... expectedStatus) throws ClientException {
        return this.doGet(requestPath, null, null, expectedStatus);
    }

    public SlingHttpResponse doHead(String requestPath, List<NameValuePair> parameters, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpHead request = new HttpHead(this.getUrl(requestPath, parameters));
        return this.doRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doPost(String requestPath, HttpEntity entity, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpPost request = new HttpPost(this.getUrl(requestPath));
        if (entity != null) {
            request.setEntity(entity);
        }
        return this.doRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doPost(String requestPath, HttpEntity entity, int ... expectedStatus) throws ClientException {
        return this.doPost(requestPath, entity, null, expectedStatus);
    }

    public SlingHttpResponse doPut(String requestPath, HttpEntity entity, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpPut request = new HttpPut(this.getUrl(requestPath));
        if (entity != null) {
            request.setEntity(entity);
        }
        return this.doRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doPatch(String requestPath, HttpEntity entity, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpPatch request = new HttpPatch(this.getUrl(requestPath));
        if (entity != null) {
            request.setEntity(entity);
        }
        return this.doRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    public SlingHttpResponse doDelete(String requestPath, List<NameValuePair> parameters, List<Header> headers, int ... expectedStatus) throws ClientException {
        HttpDelete request = new HttpDelete(this.getUrl(requestPath, parameters));
        return this.doRequest((HttpUriRequest)request, headers, expectedStatus);
    }

    @Override
    public void close() throws IOException {
        this.http.close();
    }

    @Deprecated
    public HttpParams getParams() {
        return this.http.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.http.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.http.execute(request);
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.http.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.http.execute(target, request);
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.http.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.http.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.http.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.http.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.http.execute(target, request, responseHandler, context);
    }
}

