/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Collections;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ItemList;

public class ArtifactGroup
extends ItemList<Artifact>
implements Comparable<ArtifactGroup> {
    private final int level;

    public ArtifactGroup(int startLevel) {
        this.level = startLevel;
    }

    @Override
    public void add(Artifact item) {
        super.add(item);
        Collections.sort(this.items);
    }

    public int getStartLevel() {
        return this.level;
    }

    public Artifact search(Artifact template) {
        Artifact found = null;
        for (Artifact current : this) {
            if (!current.getGroupId().equals(template.getGroupId()) || !current.getArtifactId().equals(template.getArtifactId()) || (current.getClassifier() != null || template.getClassifier() != null) && !current.getClassifier().equals(template.getClassifier()) || !current.getType().equals(template.getType())) continue;
            found = current;
            break;
        }
        return found;
    }

    @Override
    public int compareTo(ArtifactGroup o) {
        if (this.level < o.level) {
            return -1;
        }
        if (this.level > o.level) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "ArtifactGroup [level=" + this.level + ", artifacts=" + this.items + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }
}

