/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JcrItemResource<T extends Item>
extends AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrItemResource.class);
    private final ResourceResolver resourceResolver;
    protected final String path;
    protected final String version;
    private final T item;
    private final ResourceMetadata metadata;

    protected JcrItemResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @Nullable String version, @NotNull T item, @NotNull ResourceMetadata metadata) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.version = version;
        this.item = item;
        this.metadata = metadata;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @NotNull
    public String getPath() {
        if (this.version == null) {
            return this.path;
        }
        if (this.version.contains(".")) {
            return String.format("%s;v='%s'", this.path, this.version);
        }
        return String.format("%s;v=%s", this.path, this.version);
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    @NotNull
    protected T getItem() {
        return this.item;
    }

    @NotNull
    protected String getResourceTypeForNode(@NotNull Node node) throws RepositoryException {
        String result = null;
        Property property = NodeUtil.getPropertyOrNull(node, "sling:resourceType");
        if (property != null) {
            result = property.getString();
        }
        if (result == null || result.length() == 0) {
            property = NodeUtil.getPropertyOrNull(node, "{http://www.jcp.org/jcr/1.0}primaryType");
            result = property != null ? property.getString() : node.getPrimaryNodeType().getName();
        }
        return result;
    }

    public static long getContentLength(@NotNull Property property) throws RepositoryException {
        if (property.isMultiple()) {
            return -1L;
        }
        long length = -1L;
        if (property.getType() == 2) {
            try {
                length = property.getLength();
            }
            catch (ValueFormatException vfe) {
                LOGGER.debug("Length of Property {} cannot be retrieved, ignored ({})", (Object)property.getPath(), (Object)vfe);
            }
        } else {
            length = property.getString().getBytes(StandardCharsets.UTF_8).length;
        }
        return length;
    }

    @Nullable
    abstract Iterator<Resource> listJcrChildren();
}

