/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.jetbrains.annotations.NotNull;

public class BooleanConverter
implements Converter {
    private final Boolean value;

    public BooleanConverter(Boolean val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    private Integer getNumber() {
        return this.value != false ? 1 : 0;
    }

    @Override
    @NotNull
    public Long toLong() {
        return this.getNumber().longValue();
    }

    @Override
    @NotNull
    public Byte toByte() {
        return this.getNumber().byteValue();
    }

    @Override
    @NotNull
    public Short toShort() {
        return this.getNumber().shortValue();
    }

    @Override
    @NotNull
    public Integer toInteger() {
        return (int)this.getNumber();
    }

    @Override
    @NotNull
    public Double toDouble() {
        return this.getNumber().doubleValue();
    }

    @Override
    @NotNull
    public Float toFloat() {
        return Float.valueOf(this.getNumber().floatValue());
    }

    @Override
    @NotNull
    public ZonedDateTime toZonedDateTime() {
        return new CalendarConverter(this.toCalendar()).toZonedDateTime();
    }

    @Override
    @NotNull
    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    @Override
    @NotNull
    public Date toDate() {
        return new Date(this.toLong());
    }

    @Override
    @NotNull
    public Boolean toBoolean() {
        return this.value;
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.getNumber().toString());
    }
}

