/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import java.text.Normalizer;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeNameNormalizer {
    private static Logger log = LoggerFactory.getLogger(NodeNameNormalizer.class);

    public static void check(Name name) {
        String normalized;
        String lname;
        if (log.isDebugEnabled() && !(lname = name.getLocalName()).equals(normalized = Normalizer.normalize(lname, Normalizer.Form.NFC))) {
            String message = "The new node name '" + NodeNameNormalizer.dump(lname) + "' is not in Unicode NFC form ('" + NodeNameNormalizer.dump(normalized) + "').";
            log.debug(message, (Throwable)new Exception("Call chain"));
        }
    }

    private static String dump(String lname) {
        StringBuilder sb = new StringBuilder();
        for (char c : lname.toCharArray()) {
            if (c > ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append(String.format("\\u%04x", c));
        }
        return sb.toString();
    }
}

