/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class PredicateDerefQuery
extends Query {
    private final Query subQuery;
    private final String refProperty;
    private final Name nameTest;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer subQueryScorer;
    private Scorer nameTestScorer;

    PredicateDerefQuery(Query subQuery, String refProperty, Name nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.subQuery = subQuery;
        this.refProperty = refProperty;
        this.nameTest = nameTest;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new DerefWeight(searcher);
    }

    @Override
    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("PredicateDerefQuery(");
        sb.append(this.subQuery);
        sb.append(", ");
        sb.append(this.nameTest);
        sb.append(", ");
        sb.append(this.refProperty);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.subQuery.rewrite(reader);
        if (cQuery == this.subQuery) {
            return this;
        }
        return new PredicateDerefQuery(cQuery, this.refProperty, this.nameTest, this.version, this.nsMappings);
    }

    private class DerefScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet subQueryHits;
        private final BitSet hits;
        private int nextDoc;

        protected DerefScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
            this.subQueryHits = new BitSet(reader.maxDoc());
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        @Override
        public int docID() {
            return this.nextDoc;
        }

        @Override
        public float score() throws IOException {
            return 1.0f;
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            if (target == Integer.MAX_VALUE) {
                this.nextDoc = Integer.MAX_VALUE;
                return this.nextDoc;
            }
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(target);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            PredicateDerefQuery.this.subQueryScorer.score(new AbstractHitCollector(){

                @Override
                protected void collect(int doc, float score) {
                    DerefScorer.this.subQueryHits.set(doc);
                }
            });
            TermDocs termDocs = this.reader.termDocs(new Term(FieldNames.PROPERTIES_SET, PredicateDerefQuery.this.refProperty));
            String prefix = FieldNames.createNamedValue(PredicateDerefQuery.this.refProperty, "");
            while (termDocs.next()) {
                int doc = termDocs.doc();
                String[] values = this.reader.document(doc).getValues(FieldNames.PROPERTIES);
                if (values == null) continue;
                for (int v = 0; v < values.length; ++v) {
                    if (!values[v].startsWith(prefix)) continue;
                    String uuid = values[v].substring(prefix.length());
                    TermDocs node = this.reader.termDocs(TermFactory.createUUIDTerm(uuid));
                    try {
                        while (node.next()) {
                            if (!this.subQueryHits.get(node.doc())) continue;
                            this.hits.set(doc);
                        }
                        continue;
                    }
                    finally {
                        node.close();
                    }
                }
            }
            final BitSet nameTestHits = new BitSet();
            if (PredicateDerefQuery.this.nameTestScorer != null) {
                PredicateDerefQuery.this.nameTestScorer.score(new AbstractHitCollector(){

                    @Override
                    protected void collect(int doc, float score) {
                        nameTestHits.set(doc);
                    }
                });
            }
            if (PredicateDerefQuery.this.nameTestScorer != null) {
                this.hits.and(nameTestHits);
            }
        }
    }

    private class DerefWeight
    extends Weight {
        private final Searcher searcher;

        private DerefWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return PredicateDerefQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            PredicateDerefQuery.this.subQueryScorer = PredicateDerefQuery.this.subQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, false);
            if (PredicateDerefQuery.this.nameTest != null) {
                PredicateDerefQuery.this.nameTestScorer = new NameQuery(PredicateDerefQuery.this.nameTest, PredicateDerefQuery.this.version, PredicateDerefQuery.this.nsMappings).weight(this.searcher).scorer(reader, scoreDocsInOrder, false);
            }
            return new DerefScorer(this.searcher.getSimilarity(), reader);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

