/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.installer.factory.packages.impl;

import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name = "Apache Sling OSGi Installer Package Transformer", description = "Allows to configure how content packages are installed through the OSGi installer")
public @interface PackageTransformerConfiguration {
    @AttributeDefinition(name = "Create Snapshots", description = "Boolean flag indicating whether prior to the installation of the package a snapshot of the repository should be created. Only relevant when hollow packages are disabled.")
    boolean shouldCreateSnapshots() default false;
    @AttributeDefinition(name = "Use hollow packages", description = "Boolean flag indicating whether hollow packages (i.e. packages not containing actual content) should be used. This prevents the package file from being copied to the repository first before being installed (i.e. reduces required disk space, improves speed) but also prevents snapshot creation and uninstallation.")
    boolean shouldCreateHollowPackages() default false;
    @AttributeDefinition(name = "Observation Manager's User Data", description = "Sets the user data on the observation manager (only affects the session used for package installation) to the given value. Leave empty to not set it. Can be used to check in EventListeners whether an event was caused by package installation/uninstallation.")
    String observationManagerUserData() default "";
    @AttributeDefinition(name = "Dependency Handling", description = "Sets the dependency handling for package installation. Must have one of the values 'IGNORE', 'BEST_EFFORT', 'REQUIRED' or 'STRICT'.")
    DependencyHandling dependencyHandling() default DependencyHandling.STRICT;
}
