/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.propertyPages;

import java.util.List;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class SlingProjectPropertyPage
extends PropertyPage {
    private static final String PAGE_ID = "org.apache.sling.ide.projectPropertyPage";
    private static final String PAGE_ID_OVERRIDE = "org.apache.sling.ide.projectPropertyPage.override";
    private Text folderText;

    public static void openPropertyDialog(Shell shell, IProject project) {
        PropertyPageManager pageManager = new PropertyPageManager();
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)project);
        List nodes = pageManager.getElements(0);
        boolean overridePresent = false;
        for (Object node : nodes) {
            if (!((IPreferenceNode)node).getId().equals(PAGE_ID_OVERRIDE)) continue;
            overridePresent = true;
            break;
        }
        String pageId = overridePresent ? PAGE_ID_OVERRIDE : PAGE_ID;
        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        new Label(c, 0).setText("Content sync root directory");
        this.folderText = new Text(c, 2048);
        this.folderText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.folderText.setText(ProjectUtil.getSyncDirectoryValue((IProject)this.getProject()).toString());
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SlingProjectPropertyPage.this.updateApplyButton();
            }
        });
        Button browseButton = new Button(c, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IProject project = SlingProjectPropertyPage.this.getProject();
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(SlingProjectPropertyPage.this.getShell(), (IContainer)project, false, null);
                dialog.showClosedProjects(false);
                dialog.setValidator(new ISelectionValidator(){

                    public String isValid(Object selection) {
                        if (!(selection instanceof IPath)) {
                            return null;
                        }
                        IPath path = (IPath)selection;
                        if (project.getFullPath().isPrefixOf(path)) {
                            return null;
                        }
                        return "The folder must be contained in the " + project.getName() + " project";
                    }
                });
                dialog.open();
                Object[] results = dialog.getResult();
                if (results == null) {
                    return;
                }
                IPath selectedPath = (IPath)results[0];
                SlingProjectPropertyPage.this.folderText.setText(selectedPath.removeFirstSegments(1).toString());
            }
        });
        Dialog.applyDialogFont((Control)c);
        return c;
    }

    public boolean isValid() {
        String path = this.folderText.getText();
        IResource member = this.getProject().findMember(path);
        if (member == null) {
            this.setErrorMessage("Resource " + path + " is not a part of project " + this.getProject().getName());
            return false;
        }
        if (member.getType() != 2) {
            this.setErrorMessage("Resource " + path + " is not a folder");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        try {
            ProjectUtil.setSyncDirectoryPath((IProject)this.getProject(), (IPath)new Path(this.folderText.getText()));
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            this.setErrorMessage("Could not refresh project " + String.valueOf(this.getProject()) + ", " + String.valueOf(e));
            return false;
        }
        catch (Error er) {
            Activator.getDefault().getPluginLogger().error("Error occurred: " + String.valueOf(er), (Throwable)er);
            throw er;
        }
        return super.performOk();
    }

    private IProject getProject() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        return project;
    }
}

