/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl.servlets;

import java.io.IOException;
import java.io.Writer;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.OptimizationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/system/fileoptim.json", "sling.servlet.methods=GET"})
public class FileOptimizerData
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 3410212658357219464L;
    @Reference
    private transient FileOptimizerService fileOptimizer;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        Resource resource = request.getResourceResolver().getResource(path);
        if (resource == null) {
            response.sendError(404, "No Resource found at path " + path);
        } else if (this.fileOptimizer.canOptimize(resource)) {
            OptimizationResult res = this.fileOptimizer.getOptimizedContents(resource);
            response.setContentType("application/json");
            JsonGenerator json = Json.createGenerator((Writer)response.getWriter());
            json.writeStartObject();
            json.write("algorithm", res.getAlgorithm());
            json.write("originalSize", res.getOriginalSize());
            json.write("optimizedSize", res.getOptimizedSize());
            json.write("optimized", res.isOptimized());
            json.write("preview", "/system/fileoptim/preview?path=" + path);
            json.write("savings", res.getSavings());
            json.writeEnd();
            json.close();
            response.flushBuffer();
        } else {
            response.sendError(400, "Resource at path " + path + " is not a file or cannot be optimized");
        }
    }
}

