/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.resource;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.feature.io.impl.felix.utils.resource.AbstractCapabilityRequirement;
import org.apache.sling.feature.io.impl.felix.utils.resource.ResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CapabilityImpl
extends AbstractCapabilityRequirement
implements Capability {
    protected final Set<String> mandatory;

    public CapabilityImpl(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
        super(res, ns, dirs, attrs);
        Set mandatory = Collections.emptySet();
        String value = (String)this.directives.get("mandatory");
        if (value != null) {
            List<String> names = ResourceBuilder.parseDelimitedString(value, ",");
            mandatory = new HashSet(names.size());
            for (String name : names) {
                if (this.attributes.containsKey(name)) {
                    mandatory.add(name);
                    continue;
                }
                throw new IllegalArgumentException("Mandatory attribute '" + name + "' does not exist.");
            }
        }
        this.mandatory = mandatory;
    }

    public CapabilityImpl(Resource resource, Capability capability) {
        this(resource, capability.getNamespace(), capability.getDirectives(), capability.getAttributes());
    }

    public boolean isAttributeMandatory(String name) {
        return !this.mandatory.isEmpty() && this.mandatory.contains(name);
    }
}

