/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.context;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.validation.context.DependencyResolver;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.jetbrains.annotations.NotNull;

public class ArchiveValidationContext
implements ValidationContext {
    private final WorkspaceFilter filter;
    @NotNull
    private final PackageProperties properties;
    @NotNull
    private final Path archivePath;
    @NotNull
    private final Collection<PackageInfo> resolvedDependencies;

    public ArchiveValidationContext(@NotNull Archive archive, @NotNull Path archivePath, @NotNull DependencyResolver resolver) throws IOException {
        this.archivePath = archivePath;
        this.properties = archive.getMetaInf().getPackageProperties();
        this.filter = archive.getMetaInf().getFilter();
        if (this.filter == null) {
            throw new IllegalStateException("Archive '" + archivePath + "' does not contain a filter.xml.");
        }
        this.resolvedDependencies = resolver.resolvePackageInfo(this.getProperties().getDependencies(), this.getProperties().getDependenciesLocations());
    }

    @Override
    @NotNull
    public PackageProperties getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    @Override
    public ValidationContext getContainerValidationContext() {
        return null;
    }

    @Override
    @NotNull
    public Path getPackageRootPath() {
        return this.archivePath;
    }

    @Override
    @NotNull
    public Collection<PackageInfo> getDependenciesPackageInfo() {
        return this.resolvedDependencies;
    }
}

