/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.extensions;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class AnalyserMetaDataExtension {
    public static final String EXTENSION_NAME = "analyser-metadata";
    static final String SYSTEM_BUNDLE_KEY = ArtifactId.fromMvnId((String)"extra-metadata:system.bundle:0").toString();
    static final String MANIFEST_KEY = "manifest";
    static final String REPORT_KEY = "report";
    static final String WARNING_KEY = "warning";
    static final String ERROR_KEY = "error";
    static final String ARTIFACT_ID_KEY = "artifactId";
    static final String SCANNER_CACHE_KEY = "scannerCacheKey";
    private final Map<ArtifactId, Map<String, String>> manifests = new HashMap<ArtifactId, Map<String, String>>();
    private final Map<ArtifactId, Boolean> reportWarnings = new HashMap<ArtifactId, Boolean>();
    private final Map<ArtifactId, Boolean> reportErrors = new HashMap<ArtifactId, Boolean>();
    private SystemBundle systemBundle;

    public static AnalyserMetaDataExtension getAnalyserMetaDataExtension(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return AnalyserMetaDataExtension.getAnalyserMetaDataExtension(ext);
    }

    public static AnalyserMetaDataExtension getAnalyserMetaDataExtension(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        return new AnalyserMetaDataExtension(ext.getJSONStructure().asJsonObject());
    }

    private AnalyserMetaDataExtension(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).equals(SYSTEM_BUNDLE_KEY)) {
                JsonObject systemBundleConfig = ((JsonValue)entry.getValue()).asJsonObject();
                JsonObject manifestObj = systemBundleConfig.getJsonObject(MANIFEST_KEY);
                String artifactId = systemBundleConfig.getJsonString(ARTIFACT_ID_KEY).getString();
                String scannerCacheKey = systemBundleConfig.getJsonString(SCANNER_CACHE_KEY).getString();
                HashMap<String, String> manifest = new HashMap<String, String>();
                for (String key : manifestObj.keySet()) {
                    manifest.put(key, manifestObj.getString(key));
                }
                this.systemBundle = new SystemBundle(manifest, ArtifactId.fromMvnId((String)artifactId), scannerCacheKey);
                continue;
            }
            ArtifactId id = ArtifactId.fromMvnId((String)((String)entry.getKey()));
            JsonObject headers = ((JsonValue)entry.getValue()).asJsonObject();
            if (headers.containsKey((Object)MANIFEST_KEY)) {
                LinkedHashMap<String, String> manifest = new LinkedHashMap<String, String>();
                JsonObject manifestHeaders = headers.getJsonObject(MANIFEST_KEY);
                for (String name : manifestHeaders.keySet()) {
                    manifest.put(name, manifestHeaders.getString(name));
                }
                this.manifests.put(id, manifest);
            }
            if (!headers.containsKey((Object)REPORT_KEY)) continue;
            JsonObject report = headers.getJsonObject(REPORT_KEY);
            if (report.containsKey((Object)WARNING_KEY)) {
                this.reportWarnings.put(id, report.getBoolean(WARNING_KEY));
            }
            if (!report.containsKey((Object)ERROR_KEY)) continue;
            this.reportErrors.put(id, report.getBoolean(ERROR_KEY));
        }
    }

    public static boolean isAnalyserMetaDataExtension(Extension ext) {
        return ext != null && ext.getName().equals(EXTENSION_NAME) && ext.getType() == ExtensionType.JSON;
    }

    public Map<String, String> getManifest(ArtifactId artifactId) {
        return this.manifests.get(artifactId);
    }

    public SystemBundle getSystemBundle() {
        return this.systemBundle;
    }

    public boolean reportWarning(ArtifactId artifactId) {
        return !this.reportWarnings.containsKey(artifactId) || this.reportWarnings.get(artifactId) != false;
    }

    public boolean reportError(ArtifactId artifactId) {
        return !this.reportErrors.containsKey(artifactId) || this.reportErrors.get(artifactId) != false;
    }

    public Extension toExtension(Extension extension) {
        if (AnalyserMetaDataExtension.isAnalyserMetaDataExtension(extension)) {
            JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)extension.getJSONStructure().asJsonObject());
            Stream.concat(Stream.concat(this.manifests.keySet().stream(), this.reportErrors.keySet().stream()), this.reportWarnings.keySet().stream()).distinct().forEachOrdered(id -> {
                JsonObjectBuilder metadata = Json.createObjectBuilder();
                if (this.manifests.containsKey(id)) {
                    JsonObjectBuilder manifest = Json.createObjectBuilder();
                    this.manifests.get(id).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)manifest).add(arg_0, arg_1));
                    metadata.add(MANIFEST_KEY, manifest);
                }
                if (this.reportErrors.containsKey(id) || this.reportWarnings.containsKey(id)) {
                    JsonObjectBuilder report = Json.createObjectBuilder();
                    if (this.reportErrors.containsKey(id)) {
                        report.add(ERROR_KEY, this.reportErrors.get(id).booleanValue());
                    }
                    if (this.reportWarnings.containsKey(id)) {
                        report.add(WARNING_KEY, this.reportWarnings.get(id).booleanValue());
                    }
                    metadata.add(REPORT_KEY, report);
                }
                builder.add(id.toMvnId(), metadata);
            });
            extension.setJSONStructure((JsonStructure)builder.build());
        }
        return extension;
    }

    public void add(BundleDescriptor ... bundleDescriptors) {
        for (BundleDescriptor descriptor : bundleDescriptors) {
            LinkedHashMap manifest = new LinkedHashMap();
            descriptor.getManifest().getMainAttributes().entrySet().stream().forEachOrdered(entry -> manifest.put(entry.getKey().toString(), (String)entry.getValue()));
            this.manifests.put(descriptor.getArtifact().getId(), manifest);
        }
    }

    public void setReportWarnings(ArtifactId id, boolean enabled) {
        this.reportWarnings.put(id, enabled);
    }

    public void setReportErrors(ArtifactId id, boolean enabled) {
        this.reportErrors.put(id, enabled);
    }

    public static class SystemBundle {
        private Map<String, String> manifest = new HashMap<String, String>();
        private ArtifactId artifactId;
        private String scannerCacheKey;

        public SystemBundle(Map<String, String> manifest, ArtifactId artifactId, String scannerCacheKey) {
            this.manifest = manifest;
            this.artifactId = artifactId;
            this.scannerCacheKey = scannerCacheKey;
        }

        public ArtifactId getArtifactId() {
            return this.artifactId;
        }

        public Map<String, String> getManifest() {
            return this.manifest;
        }

        public String getScannerCacheKey() {
            return this.scannerCacheKey;
        }
    }
}

