/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.impl.DistributionParameter;

public class RequestUtils {
    public static DistributionRequest fromServletRequest(HttpServletRequest request) {
        String action = request.getParameter(DistributionParameter.ACTION.toString());
        String[] paths = request.getParameterValues(DistributionParameter.PATH.toString());
        String deepParam = request.getParameter(DistributionParameter.DEEP.toString());
        boolean deep = false;
        if ("true".equals(deepParam)) {
            deep = true;
        }
        if (paths == null) {
            paths = new String[]{};
        }
        return new SimpleDistributionRequest(DistributionRequestType.fromName((String)action), deep, paths);
    }

    public static URI appendDistributionRequest(URI uri, DistributionRequest distributionRequest) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        uriBuilder.addParameter(DistributionParameter.ACTION.toString(), distributionRequest.getRequestType().name());
        String[] paths = distributionRequest.getPaths();
        if (paths != null) {
            for (String path : paths) {
                uriBuilder.addParameter(DistributionParameter.PATH.toString(), path);
            }
        }
        return uriBuilder.build();
    }
}

