/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.component.impl.DistributionComponent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.resources.impl.common.AbstractReadableResourceProvider;
import org.apache.sling.distribution.resources.impl.common.SimplePathInfo;

public class DistributionServiceResourceProvider
extends AbstractReadableResourceProvider {
    private final DistributionComponentKind kind;
    private final DistributionComponentProvider componentProvider;

    DistributionServiceResourceProvider(String kind, DistributionComponentProvider componentProvider, String resourceRoot) {
        super(resourceRoot);
        this.kind = DistributionComponentKind.fromName(kind);
        this.componentProvider = componentProvider;
    }

    @Override
    protected Map<String, Object> getInternalResourceProperties(ResourceResolver resolver, SimplePathInfo pathInfo) {
        DistributionComponent<?> component;
        if (pathInfo.isRoot()) {
            return this.getResourceRootProperties();
        }
        if (pathInfo.isMain()) {
            return this.getResourceProperties(resolver, pathInfo.getMainResourceName());
        }
        if (pathInfo.isChild() && (component = this.componentProvider.getComponent(this.kind, pathInfo.getMainResourceName())) != null) {
            return this.getChildResourceProperties(component, pathInfo.getChildResourceName());
        }
        return null;
    }

    @Override
    protected Iterable<String> getInternalResourceChildren(ResourceResolver resolver, SimplePathInfo pathInfo) {
        DistributionComponent<?> component;
        if (pathInfo.isMain() && (component = this.componentProvider.getComponent(this.kind, pathInfo.getMainResourceName())) != null) {
            return this.getChildResourceChildren(component, pathInfo.getChildResourceName());
        }
        return null;
    }

    private Map<String, Object> getResourceProperties(ResourceResolver resolver, String resourceName) {
        DistributionComponent<?> component = this.componentProvider.getComponent(this.kind, resourceName);
        if (component != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("name", resourceName);
            properties.put("internal:adaptable", component.getService());
            String resourceType = this.kind.getResourceType();
            properties.put("sling:resourceType", resourceType);
            return properties;
        }
        return null;
    }

    private Map<String, Object> getResourceRootProperties() {
        List<DistributionComponent<?>> componentList = this.componentProvider.getComponents(this.kind);
        ArrayList<String> nameList = new ArrayList<String>();
        for (DistributionComponent<?> component : componentList) {
            nameList.add(component.getName());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("items", nameList.toArray(new String[nameList.size()]));
        String resourceType = this.kind.getRootResourceType();
        result.put("sling:resourceType", resourceType);
        return result;
    }

    Map<String, Object> getChildResourceProperties(DistributionComponent<?> component, String childResourceName) {
        return null;
    }

    Iterable<String> getChildResourceChildren(DistributionComponent<?> component, String childResourceName) {
        return null;
    }
}

