/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.distribution.agent.impl.ForwardDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.PrivilegeDistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.QueueDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.ReverseDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.SyncDistributionAgentFactory;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.packaging.impl.exporter.AgentDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporterFactory;
import org.apache.sling.distribution.packaging.impl.importer.LocalDistributionPackageImporterFactory;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporterFactory;
import org.apache.sling.distribution.serialization.impl.vlt.VaultDistributionPackageBuilderFactory;
import org.apache.sling.distribution.transport.impl.UserCredentialsDistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.impl.DistributionEventDistributeDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.JcrEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.PersistedJcrEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.ResourceEventDistributionTriggerFactory;
import org.apache.sling.distribution.trigger.impl.ScheduledDistributionTriggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DistributionComponentFactoryMap.class})
@Designate(ocd=Config.class)
public class DistributionComponentFactoryMap {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String[] MAPPING_AGENT_DEFAULT = new String[]{String.format("simple:%s", SimpleDistributionAgentFactory.class.getName()), String.format("sync:%s", SyncDistributionAgentFactory.class.getName()), String.format("forward:%s", ForwardDistributionAgentFactory.class.getName()), String.format("reverse:%s", ReverseDistributionAgentFactory.class.getName()), String.format("queue:%s", QueueDistributionAgentFactory.class.getName())};
    private static final String[] MAPPING_IMPORTER_DEFAULT = new String[]{String.format("local:%s", LocalDistributionPackageImporterFactory.class.getName()), String.format("remote:%s", RemoteDistributionPackageImporterFactory.class.getName())};
    private static final String[] MAPPING_EXPORTER_DEFAULT = new String[]{String.format("local:%s", LocalDistributionPackageExporterFactory.class.getName()), String.format("remote:%s", RemoteDistributionPackageExporterFactory.class.getName()), String.format("agent:%s", AgentDistributionPackageExporterFactory.class.getName())};
    private static final String[] MAPPING_QUEUE_PROVIDER_DEFAULT = new String[]{String.format("simple:%s", SimpleDistributionAgentFactory.class.getName()), String.format("sync:%s", SyncDistributionAgentFactory.class.getName()), String.format("forward:%s", ForwardDistributionAgentFactory.class.getName()), String.format("reverse:%s", ReverseDistributionAgentFactory.class.getName()), String.format("queue:%s", QueueDistributionAgentFactory.class.getName())};
    private static final String[] MAPPING_QUEUE_STRATEGY_DEFAULT = new String[]{String.format("simple:%s", SimpleDistributionAgentFactory.class.getName()), String.format("sync:%s", SyncDistributionAgentFactory.class.getName()), String.format("forward:%s", ForwardDistributionAgentFactory.class.getName()), String.format("reverse:%s", ReverseDistributionAgentFactory.class.getName()), String.format("queue:%s", QueueDistributionAgentFactory.class.getName())};
    private static final String[] MAPPING_TRANSPORT_SECRET_PROVIDER_DEFAULT = new String[]{String.format("user:%s", UserCredentialsDistributionTransportSecretProvider.class.getName())};
    private static final String[] MAPPING_PACKAGE_BUILDER_DEFAULT = new String[]{String.format("filevlt:%s", VaultDistributionPackageBuilderFactory.class.getName()), String.format("jcrvlt:%s", VaultDistributionPackageBuilderFactory.class.getName())};
    private static final String[] MAPPING_REQUEST_AUTHORIZATION_DEFAULT = new String[]{String.format("privilege:%s", PrivilegeDistributionRequestAuthorizationStrategy.class.getName())};
    private static final String[] MAPPING_TRIGGER_DEFAULT = new String[]{String.format("resourceEvent:%s", ResourceEventDistributionTriggerFactory.class.getName()), String.format("scheduledEvent:%s", ScheduledDistributionTriggerFactory.class.getName()), String.format("distributionEvent:%s", DistributionEventDistributeDistributionTriggerFactory.class.getName()), String.format("persistedJcrEvent:%s", PersistedJcrEventDistributionTriggerFactory.class.getName()), String.format("jcrEvent:%s", JcrEventDistributionTriggerFactory.class.getName())};
    private final Map<DistributionComponentKind, Map<String, String>> mapping = new HashMap<DistributionComponentKind, Map<String, String>>();

    @Activate
    protected void activate(Config conf) {
        this.mapping.put(DistributionComponentKind.AGENT, this.parse(conf.mapping_agent(), MAPPING_AGENT_DEFAULT));
        this.mapping.put(DistributionComponentKind.IMPORTER, this.parse(conf.mapping_importer(), MAPPING_IMPORTER_DEFAULT));
        this.mapping.put(DistributionComponentKind.EXPORTER, this.parse(conf.mapping_exporter(), MAPPING_EXPORTER_DEFAULT));
        this.mapping.put(DistributionComponentKind.QUEUE_PROVIDER, this.parse(conf.mapping_queueProvider(), MAPPING_QUEUE_PROVIDER_DEFAULT));
        this.mapping.put(DistributionComponentKind.QUEUE_STRATEGY, this.parse(conf.mapping_queueStrategy(), MAPPING_QUEUE_STRATEGY_DEFAULT));
        this.mapping.put(DistributionComponentKind.TRANSPORT_SECRET_PROVIDER, this.parse(conf.mapping_transportSecretProvider(), MAPPING_TRANSPORT_SECRET_PROVIDER_DEFAULT));
        this.mapping.put(DistributionComponentKind.PACKAGE_BUILDER, this.parse(conf.mapping_packageBuilder(), MAPPING_PACKAGE_BUILDER_DEFAULT));
        this.mapping.put(DistributionComponentKind.REQUEST_AUTHORIZATION, this.parse(conf.mapping_requestAuthorization(), MAPPING_REQUEST_AUTHORIZATION_DEFAULT));
        this.mapping.put(DistributionComponentKind.TRIGGER, this.parse(conf.mapping_trigger(), MAPPING_TRIGGER_DEFAULT));
    }

    String getType(DistributionComponentKind kind, @NotNull String factoryPid) {
        Map<String, String> entries = this.getEntries(kind);
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            if (!factoryPid.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    String getFactoryPid(DistributionComponentKind kind, String type) {
        return this.getEntries(kind).get(type);
    }

    List<String> getFactoryPids(DistributionComponentKind kind) {
        return new ArrayList<String>(this.getEntries(kind).values());
    }

    private Map<String, String> parse(@Nullable String[] mappings, @NotNull String[] defaultMappings) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        parsed.putAll(this.parse(defaultMappings));
        if (mappings != null) {
            parsed.putAll(this.parse(mappings));
        }
        return parsed;
    }

    private Map<String, String> parse(@NotNull String[] mappings) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String mapping : mappings) {
            String[] chunks = mapping.split(":");
            if (chunks.length != 2) {
                this.log.info(String.format("Skipping invalid mapping entry %s", mapping));
                continue;
            }
            map.put(chunks[0], chunks[1]);
        }
        return map;
    }

    private Map<String, String> getEntries(DistributionComponentKind kind) {
        Map<String, String> entries = this.mapping.get((Object)kind);
        if (entries == null) {
            throw new IllegalArgumentException(String.format("No mapping for components kind %s", new Object[]{kind}));
        }
        return entries;
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition
        public String[] mapping_agent();

        @AttributeDefinition
        public String[] mapping_importer();

        @AttributeDefinition
        public String[] mapping_exporter();

        @AttributeDefinition
        public String[] mapping_queueProvider();

        @AttributeDefinition
        public String[] mapping_queueStrategy();

        @AttributeDefinition
        public String[] mapping_transportSecretProvider();

        @AttributeDefinition
        public String[] mapping_packageBuilder();

        @AttributeDefinition
        public String[] mapping_requestAuthorization();

        @AttributeDefinition
        public String[] mapping_trigger();
    }
}

