/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.common.DistributionException;
import org.jetbrains.annotations.NotNull;

public class PrivilegeDistributionRequestAuthorizationStrategy
implements DistributionRequestAuthorizationStrategy {
    private final String jcrPrivilege;
    private final String[] additionalJcrPrivilegesForAdd;
    private final String[] additionalJcrPrivilegesForDelete;

    public PrivilegeDistributionRequestAuthorizationStrategy(String jcrPrivilege, String[] additionalJcrPrivilegesForAdd, String[] additionalJcrPrivilegesForDelete) {
        if (jcrPrivilege == null || additionalJcrPrivilegesForAdd == null || additionalJcrPrivilegesForDelete == null) {
            throw new IllegalArgumentException("Missing required privilege(s).");
        }
        this.jcrPrivilege = jcrPrivilege;
        this.additionalJcrPrivilegesForAdd = additionalJcrPrivilegesForAdd;
        this.additionalJcrPrivilegesForDelete = additionalJcrPrivilegesForDelete;
    }

    @Override
    public void checkPermission(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest) throws DistributionException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new DistributionException("cannot obtain a Session");
        }
        try {
            if (DistributionRequestType.ADD.equals((Object)distributionRequest.getRequestType())) {
                this.checkPermissionForAdd(session, distributionRequest.getPaths());
            } else if (DistributionRequestType.DELETE.equals((Object)distributionRequest.getRequestType())) {
                this.checkPermissionForDelete(session, distributionRequest.getPaths());
            }
        }
        catch (RepositoryException e) {
            throw new DistributionException("Not enough privileges");
        }
    }

    private void checkPermissionForAdd(Session session, String[] paths) throws RepositoryException, DistributionException {
        AccessControlManager acMgr = session.getAccessControlManager();
        Privilege[] privileges = PrivilegeDistributionRequestAuthorizationStrategy.computePrivileges(acMgr, this.jcrPrivilege, this.additionalJcrPrivilegesForAdd);
        for (String path : paths) {
            if (acMgr.hasPrivileges(path, privileges)) continue;
            throw new DistributionException("Not enough privileges");
        }
    }

    private void checkPermissionForDelete(Session session, String[] paths) throws RepositoryException, DistributionException {
        AccessControlManager acMgr = session.getAccessControlManager();
        Privilege[] privileges = PrivilegeDistributionRequestAuthorizationStrategy.computePrivileges(acMgr, this.jcrPrivilege, this.additionalJcrPrivilegesForDelete);
        for (String path : paths) {
            String closestParentPath = this.getClosestParent(session, path);
            if (closestParentPath != null && acMgr.hasPrivileges(closestParentPath, privileges)) continue;
            throw new DistributionException("Not enough privileges");
        }
    }

    private String getClosestParent(Session session, String path) throws RepositoryException {
        do {
            if (!session.nodeExists(path)) continue;
            return path;
        } while ((path = Text.getRelativeParent((String)path, (int)1)) != null && path.length() > 0);
        return null;
    }

    private static Privilege[] computePrivileges(AccessControlManager acMgr, String jcrPrivilege, String[] additionalJcrPrivileges) throws RepositoryException {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        privileges.add(acMgr.privilegeFromName(jcrPrivilege));
        for (String privilege : additionalJcrPrivileges) {
            privileges.add(acMgr.privilegeFromName(privilege));
        }
        return privileges.toArray(new Privilege[0]);
    }
}

