/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.cluster;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.oak.Config;
import org.apache.sling.discovery.oak.cluster.InstanceInfo;
import org.apache.sling.discovery.oak.cluster.InstanceReadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IdMapService idMapService;
    private final ResourceResolver resourceResolver;
    private final Config config;
    private final Map<Integer, InstanceInfo> seenLocalInstances;

    public ClusterReader(ResourceResolver resourceResolver, Config config, IdMapService idMapService, Map<Integer, InstanceInfo> seenLocalInstances) {
        this.resourceResolver = resourceResolver;
        this.config = config;
        this.idMapService = idMapService;
        this.seenLocalInstances = seenLocalInstances == null ? new HashMap() : seenLocalInstances;
    }

    private long readSyncToken(String slingId) {
        if (slingId == null) {
            throw new IllegalStateException("slingId must not be null");
        }
        Resource syncTokenNode = this.resourceResolver.getResource(this.config.getSyncTokenPath());
        if (syncTokenNode == null) {
            return -1L;
        }
        ValueMap resourceMap = (ValueMap)syncTokenNode.adaptTo(ValueMap.class);
        if (resourceMap == null) {
            return -1L;
        }
        String syncTokenStr = (String)resourceMap.get(slingId, String.class);
        if (syncTokenStr == null) {
            return -1L;
        }
        try {
            return Long.parseLong(syncTokenStr);
        }
        catch (NumberFormatException nfe) {
            this.logger.warn("readSyncToken: unparsable (non long) syncToken: {}", (Object)syncTokenStr);
            return -1L;
        }
    }

    private String readLeaderElectionId(String slingId) {
        if (slingId == null) {
            throw new IllegalStateException("slingId must not be null");
        }
        String myClusterNodePath = this.config.getClusterInstancesPath() + "/" + slingId;
        Resource myClusterNode = this.resourceResolver.getResource(myClusterNodePath);
        if (myClusterNode == null) {
            return null;
        }
        ValueMap resourceMap = (ValueMap)myClusterNode.adaptTo(ValueMap.class);
        String result = (String)resourceMap.get("leaderElectionId", String.class);
        return result;
    }

    public InstanceReadResult readInstance(int clusterNodeId, boolean failOnMissingSyncToken, long seqNum) throws PersistenceException {
        String slingId = this.idMapService.toSlingId(clusterNodeId, this.resourceResolver);
        if (slingId == null) {
            this.idMapService.clearCache();
            return InstanceReadResult.fromErrorMsg("no slingId mapped for clusterNodeId=" + clusterNodeId);
        }
        String leaderElectionId = this.readLeaderElectionId(slingId);
        if (leaderElectionId == null) {
            return InstanceReadResult.fromErrorMsg("no leaderElectionId available yet for slingId=" + slingId);
        }
        boolean hasSeenLocalInstance = this.hasSeenLocalInstance(clusterNodeId, slingId, leaderElectionId);
        long syncToken = this.readSyncToken(slingId);
        if (failOnMissingSyncToken && !hasSeenLocalInstance && (syncToken == -1L || seqNum != -1L && syncToken < seqNum)) {
            return InstanceReadResult.fromErrorMsg("no valid syncToken available yet for slingId=" + slingId + ", syncToken=" + syncToken);
        }
        return InstanceReadResult.fromInstance(new InstanceInfo(clusterNodeId, slingId, syncToken, leaderElectionId));
    }

    private boolean hasSeenLocalInstance(int clusterNodeId, String slingId, String leaderElectionId) {
        InstanceInfo instance = this.seenLocalInstances.get(clusterNodeId);
        if (instance == null) {
            return false;
        }
        return instance.getSlingId().equals(slingId) && instance.getLeaderElectionId().equals(leaderElectionId);
    }
}

