/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.Map;
import org.apache.sling.commons.scheduler.impl.ConfigHolder;

class MetricsHelper {
    static final String UNKNOWN_JOBNAME_SUFFIX = "unknown";

    MetricsHelper() {
    }

    static String deriveFilterName(ConfigHolder configHolder, Object job) {
        if (configHolder == null) {
            return null;
        }
        if (job == null) {
            return null;
        }
        Class<?> jobClass = job.getClass();
        String packageName = jobClass.getPackage().getName();
        Map<String, String> filterDefinitionMap = configHolder.getFilterDefinitions().get(packageName);
        if (filterDefinitionMap == null) {
            return null;
        }
        String jobToStr = jobClass.getName();
        int dollarPos = jobToStr.indexOf("$");
        if (dollarPos != -1) {
            jobToStr = jobToStr.substring(0, dollarPos);
        }
        return filterDefinitionMap.get(jobToStr);
    }

    static String asMetricsSuffix(String jobName) {
        String[] split;
        if (jobName == null || jobName.length() == 0) {
            return UNKNOWN_JOBNAME_SUFFIX;
        }
        StringBuffer shortified = new StringBuffer();
        int dollarPos = jobName.indexOf("$");
        if (dollarPos != -1) {
            jobName = jobName.substring(0, dollarPos);
        }
        if ((split = jobName.split("\\.")).length <= 2) {
            shortified.append(jobName);
        } else {
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                if (i < split.length - 2) {
                    if (s.length() <= 0) continue;
                    shortified.append(s.substring(0, 1));
                    continue;
                }
                shortified.append(".").append(s);
            }
        }
        return shortified.toString();
    }
}

