/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.usergenerated.impl;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.cms.core.usergenerated.impl.UserGeneratedContentConfig;
import org.apache.sling.cms.usergenerated.UGCBucketConfig;
import org.apache.sling.cms.usergenerated.UserGeneratedContentService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UserGeneratedContentService.class})
@Designate(ocd=UserGeneratedContentConfig.class)
public class UserGeneratedContentServiceImpl
implements UserGeneratedContentService {
    private static final Logger log = LoggerFactory.getLogger(UserGeneratedContentServiceImpl.class);
    @Reference
    private ResourceResolverFactory factory;
    private UserGeneratedContentConfig config;
    private ResourceResolver serviceResolver;

    @Activate
    public void activate(UserGeneratedContentConfig config) throws LoginException {
        this.config = config;
        log.debug("Connecting with service user");
        HashMap<String, String> serviceParams = new HashMap<String, String>();
        serviceParams.put("sling.service.subservice", "sling-cms-ugc");
        this.serviceResolver = this.factory.getServiceResourceResolver(serviceParams);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceResolver != null) {
            this.serviceResolver.close();
        }
    }

    public Resource createUGCContainer(SlingHttpServletRequest request, UGCBucketConfig bucketConfig, String preview, String targetPath) throws PersistenceException {
        this.serviceResolver.refresh();
        Resource resource = null;
        log.debug("Creating content of type {} in bucket {}", (Object)bucketConfig.getContentType(), (Object)bucketConfig.getBucket());
        HashMap<String, Object> resourceProperties = new HashMap<String, Object>();
        resourceProperties.put("jcr:primaryType", "sling:UGC");
        resourceProperties.put("approveaction", bucketConfig.getAction().toString());
        resourceProperties.put("contenttype", bucketConfig.getContentType().toString());
        resourceProperties.put("preview", preview);
        resourceProperties.put("published", false);
        resourceProperties.put("referrer", request.getHeader("referer"));
        if (StringUtils.isNotBlank((CharSequence)targetPath)) {
            resourceProperties.put("targetpath", targetPath);
        }
        resourceProperties.put("user", request.getResourceResolver().getUserID());
        resourceProperties.put("useragent", request.getHeader("User-Agent"));
        resourceProperties.put("userip", request.getRemoteAddr());
        String contentPath = this.generatePath(bucketConfig);
        log.debug("Creating article contents {}", (Object)contentPath);
        resource = ResourceUtil.getOrCreateResource((ResourceResolver)this.serviceResolver, (String)contentPath, resourceProperties, (String)"sling:OrderedFolder", (boolean)true);
        return resource;
    }

    private String generatePath(UGCBucketConfig bucketConfig) {
        String uuid = UUID.randomUUID().toString();
        int depth = bucketConfig.getPathDepth();
        if (depth == -1) {
            depth = this.config.defaultPathDepth();
        }
        Object[] pathSegments = new String[depth];
        for (int i = 0; i < pathSegments.length; ++i) {
            pathSegments[i] = String.valueOf(uuid.charAt(i));
        }
        if (pathSegments.length > 0) {
            return this.config.ugcRoot() + "/" + bucketConfig.getBucket() + "/" + StringUtils.join((Object[])pathSegments, (String)"/") + "/" + uuid;
        }
        return this.config.ugcRoot() + "/" + bucketConfig.getBucket() + "/" + uuid;
    }
}

