/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms;

import java.util.HashMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableJobExecutor
implements JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableJobExecutor.class);
    private static final String USER_ID_KEY = "_userId";

    public abstract JobExecutionResult doProcess(Job var1, JobExecutionContext var2, ResourceResolver var3);

    public abstract String getConfigurationPath();

    public abstract ResourceResolverFactory getResolverFactory();

    public abstract String getTitleKey();

    public abstract String getTopic();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JobExecutionResult process(Job job, JobExecutionContext context) {
        try (ResourceResolver resolver = null;){
            HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
            authenticationInfo.put("user.impersonation", job.getProperty(USER_ID_KEY));
            resolver = this.getResolverFactory().getAdministrativeResourceResolver(authenticationInfo);
            JobExecutionResult jobExecutionResult = this.doProcess(job, context, resolver);
            return jobExecutionResult;
        }
    }
}

