/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.clam.http.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.clam.http.internal.ClamJcrScanServletConfiguration;
import org.apache.sling.clam.http.internal.RequestUtil;
import org.apache.sling.clam.http.internal.ResponseUtil;
import org.apache.sling.clam.internal.ClamUtil;
import org.apache.sling.clam.jcr.NodeDescendingJcrPropertyDigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Apache Sling Clam JCR Scan Servlet", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ClamJcrScanServletConfiguration.class)
public class ClamJcrScanServlet
extends SlingAllMethodsServlet {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile NodeDescendingJcrPropertyDigger digger;
    private ClamJcrScanServletConfiguration configuration;
    private Pattern pattern;
    private Set<Integer> propertyTypes;
    private final Logger logger = LoggerFactory.getLogger(ClamJcrScanServlet.class);

    @Activate
    private void activate(ClamJcrScanServletConfiguration configuration) throws Exception {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Modified
    private void modified(ClamJcrScanServletConfiguration configuration) throws Exception {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
        this.pattern = null;
        this.propertyTypes = null;
    }

    private void configure(ClamJcrScanServletConfiguration configuration) throws Exception {
        this.pattern = Pattern.compile(configuration.digger_default_property_path_pattern());
        this.propertyTypes = ClamUtil.propertyTypesFromNames(configuration.digger_default_property_types());
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        int maxDepth;
        long maxLength;
        Set<Integer> propertyTypes;
        Pattern pattern;
        String path;
        List<String> groups = Arrays.asList(this.configuration.scan_authorized_groups());
        if (!groups.isEmpty()) {
            boolean isAuthorized = false;
            try {
                isAuthorized = RequestUtil.isAuthorized(request, groups);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            if (!isAuthorized) {
                ResponseUtil.handleError(response, 403, null);
                return;
            }
        }
        try {
            path = RequestUtil.path(request);
            pattern = RequestUtil.pattern(request, this.pattern);
            propertyTypes = RequestUtil.propertyTypes(request, this.propertyTypes);
            maxLength = RequestUtil.maxLength(request, this.configuration.digger_default_property_length_max());
            maxDepth = RequestUtil.maxDepth(request, this.configuration.digger_default_node_depth_max());
        }
        catch (Exception e) {
            ResponseUtil.handleError(response, 400, e.getMessage());
            return;
        }
        Resource resource = request.getResourceResolver().getResource(path);
        if (resource == null) {
            ResponseUtil.handleError(response, 400, "No resource at given path found: " + path);
            return;
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            ResponseUtil.handleError(response, 400, "Resource at given path is not a Node: " + path);
            return;
        }
        try {
            this.logger.debug("digging in {} (not deeper than {} levels) for properties of types {} matching {} limited by {} bytes", new Object[]{node.getPath(), maxDepth, propertyTypes, pattern, maxLength});
            this.digger.dig(node, pattern, propertyTypes, maxLength, maxDepth);
        }
        catch (Exception e) {
            ResponseUtil.handleError(response, 500, e.getMessage());
        }
    }
}

