/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.jakartawrappers.ServletExceptionUtil;
import org.apache.felix.http.javaxwrappers.FilterConfigWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaxToJakartaFilterWrapper
implements Filter {
    private final javax.servlet.Filter filter;

    @Nullable
    public static Filter toJakartaFilter(@Nullable javax.servlet.Filter filter) {
        if (filter != null) {
            return new JavaxToJakartaFilterWrapper(filter);
        }
        return null;
    }

    public JavaxToJakartaFilterWrapper(javax.servlet.Filter filter) {
        this.filter = filter;
    }

    public void init(jakarta.servlet.FilterConfig config) throws jakarta.servlet.ServletException {
        try {
            this.filter.init((FilterConfig)new FilterConfigWrapper(config));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException((ServletException)e);
        }
    }

    public void doFilter(jakarta.servlet.ServletRequest request, jakarta.servlet.ServletResponse response, FilterChain chain) throws IOException, jakarta.servlet.ServletException {
        try {
            this.filter.doFilter(JakartaToJavaxRequestWrapper.toJavaxRequest(request), JakartaToJavaxResponseWrapper.toJavaxResponse(response), (javax.servlet.FilterChain)new FilterChainWrapper(chain));
        }
        catch (ServletException e) {
            throw ServletExceptionUtil.getServletException((ServletException)e);
        }
    }

    public void destroy() {
        this.filter.destroy();
    }

    public static class FilterChainWrapper
    implements javax.servlet.FilterChain {
        private final FilterChain filterChain;

        public FilterChainWrapper(@NotNull FilterChain chain) {
            this.filterChain = chain;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            try {
                this.filterChain.doFilter(JavaxToJakartaRequestWrapper.toJakartaRequest(request), JavaxToJakartaResponseWrapper.toJakartaResponse(response));
            }
            catch (jakarta.servlet.ServletException e) {
                throw org.apache.felix.http.javaxwrappers.ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)e);
            }
        }
    }
}

