/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextInternal;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.Part;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.http.HttpUtils;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.EmptyAsyncContext;
import org.apache.servicecomb.foundation.vertx.http.FileUploadPart;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxServerRequestToHttpServletRequest
extends AbstractHttpServletRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxServerRequestToHttpServletRequest.class);
    private static final EmptyAsyncContext EMPTY_ASYNC_CONTEXT = new EmptyAsyncContext();
    private final RoutingContext context;
    private final HttpServerRequest vertxRequest;
    private Cookie[] cookies;
    private ServletInputStream inputStream;
    private String path;
    private final SocketAddress socketAddress;
    private Map<String, String[]> parameterMap;
    private String characterEncoding;

    public VertxServerRequestToHttpServletRequest(RoutingContext context, String path) {
        this(context);
        this.path = path;
    }

    public VertxServerRequestToHttpServletRequest(RoutingContext context) {
        this.context = context;
        this.vertxRequest = context.request();
        this.socketAddress = this.vertxRequest.remoteAddress();
        super.setBodyBuffer(context.body().buffer());
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        super.setBodyBuffer(bodyBuffer);
        if (this.context instanceof RoutingContextInternal) {
            RoutingContextInternal contextInternal = (RoutingContextInternal)this.context;
            contextInternal.setBody(bodyBuffer);
        }
        this.inputStream = null;
    }

    @Override
    public String getContentType() {
        return this.vertxRequest.getHeader("Content-Type");
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Set cookieSet = this.context.request().cookies();
            Cookie[] tmpCookies = new Cookie[cookieSet.size()];
            int idx = 0;
            for (io.vertx.core.http.Cookie vertxCookie : cookieSet) {
                Cookie cookie;
                tmpCookies[idx] = cookie = new Cookie(vertxCookie.getName(), vertxCookie.getValue());
                ++idx;
            }
            this.cookies = tmpCookies;
        }
        return this.cookies;
    }

    @Override
    public String getParameter(String name) {
        if (this.parameterMap != null) {
            String[] values = this.parameterMap.get(name);
            return values == null ? null : values[0];
        }
        return this.vertxRequest.getParam(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this.parameterMap != null) {
            return Collections.enumeration(this.parameterMap.keySet());
        }
        return Collections.enumeration(this.vertxRequest.params().names());
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.parameterMap != null) {
            return this.parameterMap.get(name);
        }
        List paramList = this.vertxRequest.params().getAll(name);
        return paramList.toArray(new String[0]);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
            MultiMap map = this.vertxRequest.params();
            for (String name : map.names()) {
                paramMap.put(name, map.getAll(name).toArray(new String[0]));
            }
            this.parameterMap = paramMap;
        }
        return this.parameterMap;
    }

    @Override
    public void setParameter(String name, String value) {
        if (this.parameterMap != null) {
            this.parameterMap.put(name, new String[]{value});
            return;
        }
        this.vertxRequest.params().set(name, value);
    }

    @Override
    public String getScheme() {
        return this.vertxRequest.scheme();
    }

    @Override
    public String getRemoteAddr() {
        return this.socketAddress.host();
    }

    @Override
    public String getRemoteHost() {
        return this.socketAddress.host();
    }

    @Override
    public int getRemotePort() {
        return this.socketAddress.port();
    }

    @Override
    public String getLocalAddr() {
        return this.vertxRequest.localAddress().host();
    }

    @Override
    public int getLocalPort() {
        return this.vertxRequest.localAddress().port();
    }

    @Override
    public String getHeader(String name) {
        return this.vertxRequest.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.vertxRequest.headers().getAll(name));
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.vertxRequest.headers().names());
    }

    @Override
    public int getIntHeader(String name) {
        String header = this.vertxRequest.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    @Override
    public String getMethod() {
        return this.vertxRequest.method().name();
    }

    @Override
    public String getPathInfo() {
        return this.vertxRequest.path();
    }

    @Override
    public String getQueryString() {
        return this.vertxRequest.query();
    }

    @Override
    public String getRequestURI() {
        if (this.path == null) {
            this.path = this.vertxRequest.path();
        }
        return this.path;
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.path == null) {
            this.path = this.vertxRequest.path();
        }
        return new StringBuffer(this.path);
    }

    @Override
    public String getServletPath() {
        return this.getPathInfo();
    }

    @Override
    public String getContextPath() {
        return "";
    }

    @Override
    public ServletInputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.context.body().buffer() == null) {
            return null;
        }
        this.inputStream = new BufferInputStream(this.context.body().buffer());
        return this.inputStream;
    }

    @Override
    public AsyncContext getAsyncContext() {
        return EMPTY_ASYNC_CONTEXT;
    }

    @Override
    public Part getPart(String name) {
        Optional<FileUpload> upload = this.context.fileUploads().stream().filter(fileUpload -> fileUpload.name().equals(name)).findFirst();
        if (!upload.isPresent()) {
            LOGGER.debug("No such file with name: {}.", (Object)name);
            return null;
        }
        FileUpload fileUpload2 = upload.get();
        return new FileUploadPart(fileUpload2);
    }

    @Override
    public Collection<Part> getParts() {
        return this.context.fileUploads().stream().map(FileUploadPart::new).collect(Collectors.toList());
    }

    public RoutingContext getContext() {
        return this.context;
    }

    @Override
    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = HttpUtils.getCharsetFromContentType((String)this.getContentType());
        }
        return this.characterEncoding;
    }
}

