/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class URLEndPoint {
    private static final String SSL_ENABLED_KEY = "sslEnabled";
    private static final String HTTP_KEY = "http://";
    private static final String HTTPS_KEY = "https://";
    private final boolean sslEnabled;
    private final Map<String, List<String>> queries;
    private final String hostOrIp;
    private final int port;

    public URLEndPoint(String endpoint) {
        URI uri = URI.create(endpoint);
        this.hostOrIp = uri.getHost();
        if (uri.getPort() < 0) {
            throw new IllegalArgumentException("port not specified.");
        }
        this.port = uri.getPort();
        this.queries = URLEndPoint.splitQuery(uri);
        this.sslEnabled = endpoint.contains(HTTPS_KEY) ? true : Boolean.parseBoolean(this.getFirst(SSL_ENABLED_KEY));
    }

    public static Map<String, List<String>> splitQuery(URI uri) {
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        List pairs = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair pair : pairs) {
            List list = queryPairs.computeIfAbsent(pair.getName(), name -> new ArrayList());
            list.add(pair.getValue());
        }
        return queryPairs;
    }

    public String getFirst(String key) {
        List<String> values = this.queries.get(key);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public String toString() {
        if (this.sslEnabled) {
            return HTTPS_KEY + this.hostOrIp + ":" + this.port;
        }
        return HTTP_KEY + this.hostOrIp + ":" + this.port;
    }
}

